/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.SpanNameProvider;
import com.github.kristofa.brave.spring.ServletHandlerInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={DefaultSpanNameProvider.class})
public class ApiTracerConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    Brave brave;

    public void addInterceptors(InterceptorRegistry registry) {
        ServerTracer tracer = this.brave.serverTracer();
        ServletHandlerInterceptor traceInterceptor = new ServletHandlerInterceptor(new ServerRequestInterceptor(tracer), new ServerResponseInterceptor(tracer), (SpanNameProvider)new DefaultSpanNameProvider(), this.brave.serverSpanThreadBinder());
        registry.addInterceptor((HandlerInterceptor)new NoPOSTHandlerInterceptorAdapter((AsyncHandlerInterceptor)traceInterceptor));
    }

    static class NoPOSTHandlerInterceptorAdapter
    implements AsyncHandlerInterceptor {
        private final AsyncHandlerInterceptor delegate;

        NoPOSTHandlerInterceptorAdapter(AsyncHandlerInterceptor delegate) {
            this.delegate = delegate;
        }

        public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
            if (!request.getMethod().equals("POST")) {
                this.delegate.afterConcurrentHandlingStarted(request, response, o);
            }
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
            return request.getMethod().equals("POST") || this.delegate.preHandle(request, response, o);
        }

        public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
            if (!request.getMethod().equals("POST")) {
                this.delegate.postHandle(request, response, o, modelAndView);
            }
        }

        public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) throws Exception {
            if (!request.getMethod().equals("POST")) {
                this.delegate.afterCompletion(request, response, o, e);
            }
        }
    }
}

