/*
 * Decompiled with CFR 0.152.
 */
package io.zipkin.server.brave;

import com.github.kristofa.brave.SpanCollector;
import com.twitter.zipkin.gen.AnnotationType;
import io.zipkin.Annotation;
import io.zipkin.BinaryAnnotation;
import io.zipkin.Endpoint;
import io.zipkin.Span;
import io.zipkin.SpanStore;
import java.io.Flushable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SpanStoreSpanCollector
implements SpanCollector,
Flushable {
    private final SpanStore spanStore;
    private final BlockingQueue<Span> queue = new LinkedBlockingQueue<Span>();
    private final int limit = 200;

    public SpanStoreSpanCollector(SpanStore spanStore) {
        this.spanStore = spanStore;
    }

    public void collect(Span span) {
        if (this.queue.offer(span) && this.queue.size() >= 200) {
            this.flush();
        }
    }

    public void collect(com.twitter.zipkin.gen.Span span) {
        this.collect(this.convert(span));
    }

    @Override
    public void flush() {
        ArrayList<Span> spans = new ArrayList<Span>(this.queue.size());
        while (!this.queue.isEmpty()) {
            Span span = (Span)this.queue.poll();
            if (span == null) continue;
            spans.add(span);
        }
        if (!spans.isEmpty()) {
            this.spanStore.accept(spans.iterator());
        }
    }

    private Span convert(com.twitter.zipkin.gen.Span span) {
        List binaries;
        Span.Builder builder = new Span.Builder();
        builder.name(span.getName()).id(span.id).parentId(span.isSetParent_id() ? Long.valueOf(span.parent_id) : null).traceId(span.trace_id).timestamp(Long.valueOf(span.timestamp)).duration(Long.valueOf(span.duration)).debug(Boolean.valueOf(span.debug));
        List annotations = span.annotations;
        if (annotations != null) {
            for (com.twitter.zipkin.gen.Annotation annotation : annotations) {
                builder.addAnnotation(SpanStoreSpanCollector.convert(annotation));
            }
        }
        if ((binaries = span.binary_annotations) != null) {
            for (com.twitter.zipkin.gen.BinaryAnnotation annotation : binaries) {
                builder.addBinaryAnnotation(SpanStoreSpanCollector.convert(annotation));
            }
        }
        return builder.build();
    }

    public void addDefaultAnnotation(String key, String value) {
    }

    public void close() {
    }

    private static Annotation convert(com.twitter.zipkin.gen.Annotation annotation) {
        return new Annotation.Builder().timestamp(annotation.timestamp).value(annotation.value).endpoint(SpanStoreSpanCollector.convert(annotation.host)).build();
    }

    private static Endpoint convert(com.twitter.zipkin.gen.Endpoint endpoint) {
        return new Endpoint.Builder().serviceName(endpoint.service_name).port(endpoint.port).ipv4(endpoint.ipv4).build();
    }

    private static BinaryAnnotation convert(com.twitter.zipkin.gen.BinaryAnnotation annotation) {
        return new BinaryAnnotation.Builder().key(annotation.key).value(annotation.getValue()).type(SpanStoreSpanCollector.convert(annotation.annotation_type)).endpoint(SpanStoreSpanCollector.convert(annotation.host)).build();
    }

    private static BinaryAnnotation.Type convert(AnnotationType type) {
        switch (type) {
            case STRING: {
                return BinaryAnnotation.Type.STRING;
            }
            case DOUBLE: {
                return BinaryAnnotation.Type.DOUBLE;
            }
            case BOOL: {
                return BinaryAnnotation.Type.BOOL;
            }
            case I16: {
                return BinaryAnnotation.Type.I16;
            }
            case I32: {
                return BinaryAnnotation.Type.I32;
            }
            case I64: {
                return BinaryAnnotation.Type.I64;
            }
        }
        return BinaryAnnotation.Type.BYTES;
    }
}

