/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import is.codion.common.db.database.Database;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportType;
import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.exception.LoginException;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.rmi.RemoteEntityConnection;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.server.EntityServer;
import is.codion.framework.server.EntityServerConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaEntityHandler
implements RequestHandler<APIGatewayV2HTTPEvent, APIGatewayV2HTTPResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaEntityHandler.class);
    private static final String SELECT = "select";
    private static final String SELECT_BY_KEY = "selectByKey";
    private static final String COUNT = "count";
    private static final String INSERT = "insert";
    private static final String INSERT_SELECT = "insertSelect";
    private static final String UPDATE = "update";
    private static final String UPDATE_SELECT = "updateSelect";
    private static final String UPDATE_BY_CONDITION = "updateByCondition";
    private static final String DELETE = "delete";
    private static final String DELETE_BY_KEY = "deleteByKey";
    private static final String VALUES = "values";
    private static final String DEPENDENCIES = "dependencies";
    private static final String IS_TRANSACTION_OPEN = "isTransactionOpen";
    private static final String START_TRANSACTION = "startTransaction";
    private static final String COMMIT_TRANSACTION = "commitTransaction";
    private static final String ROLLBACK_TRANSACTION = "rollbackTransaction";
    private static final String SET_QUERY_CACHE_ENABLED = "setQueryCacheEnabled";
    private static final String IS_QUERY_CACHE_ENABLED = "isQueryCacheEnabled";
    private static final String PROCEDURE = "procedure";
    private static final String FUNCTION = "function";
    private static final String REPORT = "report";
    private static final String ENTITIES_SERIAL = "/entities/serial/";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String GET_POST_OPTIONS = "GET, POST, OPTIONS";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String X_LAMBDA_REQUEST_ID = "X-Lambda-Request-Id";
    private static final String ENTITIES = "entities";
    private static final String CLOSE = "close";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_TYPE = "clientType";
    private static final String OPTIONS = "OPTIONS";
    private static final String HEALTH = "/health";
    private static final String BASIC = "Basic ";
    private static final int BASIC_LENGTH = 6;
    private static final Set<String> NO_BODY_OPERATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("entities", "close", "startTransaction", "commitTransaction", "rollbackTransaction", "isTransactionOpen", "isQueryCacheEnabled")));
    private static final Set<String> NO_RETURN_DATA_OPERATIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("close", "startTransaction", "commitTransaction", "rollbackTransaction")));
    private final EntityServer entityServer;

    public LambdaEntityHandler() {
        try {
            this.entityServer = EntityServer.startServer((EntityServerConfiguration)((EntityServerConfiguration.Builder)EntityServerConfiguration.builder((int)1098, (int)1099).database(Database.instance()).sslEnabled(false)).build());
            LOG.info("EntityServer started successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start EntityServer", e);
        }
    }

    public final APIGatewayV2HTTPResponse handleRequest(APIGatewayV2HTTPEvent input, Context context) {
        APIGatewayV2HTTPResponse.APIGatewayV2HTTPResponseBuilder response = APIGatewayV2HTTPResponse.builder();
        try {
            String path = LambdaEntityHandler.extractPath(input);
            if (OPTIONS.equals(input.getRequestContext().getHttp().getMethod())) {
                LambdaEntityHandler.handleOptionsRequest(response);
            } else if (path.startsWith(ENTITIES_SERIAL)) {
                String operation = path.substring(ENTITIES_SERIAL.length());
                this.handleRequest(input, operation, response, context);
            } else if (path.startsWith(HEALTH)) {
                this.handleHealthCheck(response);
            } else {
                LambdaEntityHandler.sendErrorResponse(response, new IllegalArgumentException("Not found: " + path), context);
            }
        }
        catch (Exception e) {
            LambdaEntityHandler.sendErrorResponse(response, e, context);
        }
        return response.build();
    }

    private static String extractPath(APIGatewayV2HTTPEvent input) {
        String path = input.getRawPath();
        return path == null || path.isEmpty() ? "/" : path;
    }

    private static void handleOptionsRequest(APIGatewayV2HTTPResponse.APIGatewayV2HTTPResponseBuilder response) {
        response.withStatusCode(200).withHeaders(LambdaEntityHandler.createOptionsHeaders()).withBody("");
    }

    private RemoteEntityConnection connection(Map<String, String> headers) throws Exception {
        if (headers == null) {
            throw new IllegalArgumentException("No authentication provided - missing headers");
        }
        User user = LambdaEntityHandler.extractUser(headers);
        String domainTypeName = LambdaEntityHandler.extractDomainTypeName(headers);
        UUID clientId = LambdaEntityHandler.extractClientId(headers);
        String clientType = LambdaEntityHandler.extractClientType(headers);
        return (RemoteEntityConnection)this.entityServer.connect(ConnectionRequest.builder().user(user).clientId(clientId).clientType(clientType).parameter("codion.client.domainType", (Object)domainTypeName).parameter("clientHost", (Object)"lambda").build());
    }

    private void handleRequest(APIGatewayV2HTTPEvent input, String operation, APIGatewayV2HTTPResponse.APIGatewayV2HTTPResponseBuilder response, Context context) throws Exception {
        if (operation.isEmpty()) {
            LambdaEntityHandler.sendErrorResponse(response, new IllegalArgumentException("Invalid path - no operation specified"), context);
            return;
        }
        RemoteEntityConnection connection = this.connection(input.getHeaders());
        if (NO_BODY_OPERATIONS.contains(operation)) {
            LambdaEntityHandler.processNoBodyOperation(operation, response, context, connection);
            return;
        }
        if (input.getBody() == null || input.getBody().isEmpty()) {
            LambdaEntityHandler.sendErrorResponse(response, new IllegalArgumentException("Empty request body for operation: " + operation), context);
            return;
        }
        byte[] requestBytes = Base64.getDecoder().decode(input.getBody());
        try (ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(requestBytes));){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);){
                LambdaEntityHandler.processOperation(operation, inputStream, outputStream, connection);
            }
            response.withStatusCode(200).withHeaders(LambdaEntityHandler.createCorsHeadersWithContent(context.getAwsRequestId())).withBody(Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray())).withIsBase64Encoded(true);
        }
    }

    private static void processOperation(String operation, ObjectInputStream input, ObjectOutputStream output, RemoteEntityConnection connection) throws Exception {
        switch (operation) {
            case "select": {
                output.writeObject(connection.select((EntityConnection.Select)input.readObject()));
                break;
            }
            case "selectByKey": {
                output.writeObject(connection.select((Collection)input.readObject()));
                break;
            }
            case "count": {
                output.writeObject(connection.count((EntityConnection.Count)input.readObject()));
                break;
            }
            case "insert": {
                output.writeObject(connection.insert((Collection)input.readObject()));
                break;
            }
            case "insertSelect": {
                output.writeObject(connection.insertSelect((Collection)input.readObject()));
                break;
            }
            case "update": {
                connection.update((Collection)input.readObject());
                break;
            }
            case "updateSelect": {
                output.writeObject(connection.updateSelect((Collection)input.readObject()));
                break;
            }
            case "delete": {
                Object deleteParam = input.readObject();
                if (deleteParam instanceof Collection) {
                    connection.delete((Collection)deleteParam);
                    break;
                }
                output.writeObject(connection.delete((Condition)deleteParam));
                break;
            }
            case "deleteByKey": {
                connection.delete((Collection)input.readObject());
                break;
            }
            case "updateByCondition": {
                output.writeObject(connection.update((EntityConnection.Update)input.readObject()));
                break;
            }
            case "values": {
                List params = (List)input.readObject();
                output.writeObject(connection.select((Column)params.get(0), (EntityConnection.Select)params.get(1)));
                break;
            }
            case "dependencies": {
                output.writeObject(connection.dependencies((Collection)input.readObject()));
                break;
            }
            case "setQueryCacheEnabled": {
                connection.queryCache(((Boolean)input.readObject()).booleanValue());
                break;
            }
            case "procedure": {
                List parameters = (List)input.readObject();
                ProcedureType procedureType = (ProcedureType)parameters.get(0);
                connection.execute(procedureType, parameters.size() > 1 ? parameters.get(1) : null);
                break;
            }
            case "function": {
                List parameters = (List)input.readObject();
                FunctionType functionType = (FunctionType)parameters.get(0);
                output.writeObject(connection.execute(functionType, parameters.size() > 1 ? parameters.get(1) : null));
                break;
            }
            case "report": {
                List parameters = (List)input.readObject();
                ReportType reportType = (ReportType)parameters.get(0);
                output.writeObject(connection.report(reportType, parameters.get(1)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operation: " + operation);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void processNoBodyOperation(String operation, APIGatewayV2HTTPResponse.APIGatewayV2HTTPResponseBuilder response, Context context, RemoteEntityConnection connection) throws Exception {
        baos = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(baos);
        try {
            var6_6 = operation;
            var7_8 = -1;
            switch (var6_6.hashCode()) {
                case -2102114367: {
                    if (!var6_6.equals("entities")) break;
                    var7_8 = 0;
                    break;
                }
                case 94756344: {
                    if (!var6_6.equals("close")) break;
                    var7_8 = 1;
                    break;
                }
                case 920552732: {
                    if (!var6_6.equals("startTransaction")) break;
                    var7_8 = 2;
                    break;
                }
                case -1592641241: {
                    if (!var6_6.equals("commitTransaction")) break;
                    var7_8 = 3;
                    break;
                }
                case 1414661466: {
                    if (!var6_6.equals("rollbackTransaction")) break;
                    var7_8 = 4;
                    break;
                }
                case 2047557566: {
                    if (!var6_6.equals("isTransactionOpen")) break;
                    var7_8 = 5;
                    break;
                }
                case 730843709: {
                    if (!var6_6.equals("isQueryCacheEnabled")) break;
                    var7_8 = 6;
                }
            }
            switch (var7_8) {
                case 0: {
                    oos.writeObject(connection.entities());
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 1: {
                    connection.close();
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                case 2: {
                    connection.startTransaction();
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                case 3: {
                    connection.commitTransaction();
                    ** break;
lbl50:
                    // 1 sources

                    break;
                }
                case 4: {
                    connection.rollbackTransaction();
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                case 5: {
                    oos.writeObject(connection.transactionOpen());
                    ** break;
lbl58:
                    // 1 sources

                    break;
                }
                case 6: {
                    oos.writeObject(connection.queryCache());
                    ** break;
lbl62:
                    // 1 sources

                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown no-body operation: " + operation);
                }
            }
        }
        finally {
            oos.close();
        }
        if (LambdaEntityHandler.NO_RETURN_DATA_OPERATIONS.contains(operation)) {
            response.withStatusCode(200).withHeaders(LambdaEntityHandler.createCorsHeaders());
        } else {
            response.withStatusCode(200).withHeaders(LambdaEntityHandler.createCorsHeadersWithContent(context.getAwsRequestId())).withBody(Base64.getEncoder().encodeToString(baos.toByteArray())).withIsBase64Encoded(true);
        }
    }

    private void handleHealthCheck(APIGatewayV2HTTPResponse.APIGatewayV2HTTPResponseBuilder response) {
        try {
            boolean available = this.entityServer.connectionsAvailable();
            String status = available ? "UP" : "DOWN";
            response.withStatusCode(200).withHeaders(LambdaEntityHandler.createJsonHeaders()).withBody("{\"status\":\"" + status + "\",\"service\":\"codion-lambda\"}");
        }
        catch (Exception e) {
            response.withStatusCode(503).withHeaders(LambdaEntityHandler.createJsonHeaders()).withBody("{\"status\":\"DOWN\",\"error\":\"" + e.getMessage() + "\"}");
        }
    }

    private static void sendErrorResponse(APIGatewayV2HTTPResponse.APIGatewayV2HTTPResponseBuilder response, Exception error, Context context) {
        int statusCode = 500;
        if (error instanceof LoginException || error.getMessage() != null && error.getMessage().contains("authentication")) {
            statusCode = 401;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (ObjectOutputStream stream = new ObjectOutputStream(outputStream);){
                stream.writeObject(error);
            }
            response.withStatusCode(statusCode).withHeaders(LambdaEntityHandler.createCorsHeadersWithContent(context.getAwsRequestId())).withBody(Base64.getEncoder().encodeToString(outputStream.toByteArray())).withIsBase64Encoded(true);
        }
        catch (Exception e) {
            context.getLogger().log("Failed to serialize error response: " + e.getMessage());
            response.withStatusCode(statusCode).withHeaders(LambdaEntityHandler.createTextHeaders()).withBody("Serialization error");
        }
    }

    private static Map<String, String> createCorsHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        headers.put(ACCESS_CONTROL_ALLOW_METHODS, GET_POST_OPTIONS);
        return headers;
    }

    private static Map<String, String> createCorsHeadersWithContent(String requestId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, APPLICATION_OCTET_STREAM);
        headers.put(X_LAMBDA_REQUEST_ID, requestId);
        headers.put(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        headers.put(ACCESS_CONTROL_ALLOW_METHODS, GET_POST_OPTIONS);
        return headers;
    }

    private static Map<String, String> createJsonHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, "application/json");
        return headers;
    }

    private static Map<String, String> createTextHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, "text/plain");
        headers.put(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        headers.put(ACCESS_CONTROL_ALLOW_METHODS, GET_POST_OPTIONS);
        return headers;
    }

    private static Map<String, String> createOptionsHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        headers.put(ACCESS_CONTROL_ALLOW_METHODS, GET_POST_OPTIONS);
        headers.put(ACCESS_CONTROL_ALLOW_HEADERS, "Content-Type, content-type, domainTypeName, domaintypename, clientId, clientid, clientType, clienttype, Authorization, authorization");
        headers.put(ACCESS_CONTROL_MAX_AGE, "86400");
        return headers;
    }

    private static User extractUser(Map<String, String> headers) {
        String auth = headers.get("authorization");
        if (auth == null) {
            auth = headers.get("Authorization");
        }
        if (auth == null || !auth.startsWith(BASIC)) {
            throw new IllegalArgumentException("No authentication provided - missing Authorization header");
        }
        try {
            return User.parse((String)new String(Base64.getDecoder().decode(auth.substring(6))));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Basic authentication format", e);
        }
    }

    private static String extractDomainTypeName(Map<String, String> headers) {
        String domainTypeName = headers.get("domaintypename");
        if (domainTypeName == null) {
            domainTypeName = headers.get("domainTypeName");
        }
        if (domainTypeName == null || domainTypeName.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing required header: domainTypeName");
        }
        return domainTypeName.trim();
    }

    private static UUID extractClientId(Map<String, String> headers) {
        String clientId = headers.get("clientid");
        if (clientId == null) {
            clientId = headers.get(CLIENT_ID);
        }
        if (clientId == null || clientId.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing required header: clientId");
        }
        try {
            return UUID.fromString(clientId.trim());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid clientId format: " + clientId, e);
        }
    }

    private static String extractClientType(Map<String, String> headers) {
        String clientType = headers.get("clienttype");
        if (clientType == null) {
            clientType = headers.get(CLIENT_TYPE);
        }
        if (clientType == null || clientType.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing required header: clientType");
        }
        return clientType.trim();
    }
}

