/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.Text;
import is.codion.common.db.database.Database;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.server.EntityServerConfiguration;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEntityServerConfiguration
implements EntityServerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntityServerConfiguration.class);
    private final ServerConfiguration serverConfiguration;
    private final Database database;
    private final User adminUser;
    private final boolean clientLogging;
    private final int idleConnectionTimeout;
    private final String connectionPoolFactory;
    private final Collection<String> domainClassNames;
    private final Collection<User> connectionPoolUsers;
    private final Map<String, Integer> clientTypeIdleConnectionTimeouts;

    DefaultEntityServerConfiguration(DefaultBuilder builder) {
        this.serverConfiguration = Objects.requireNonNull(builder.serverConfigurationBuilder.build());
        this.database = builder.database;
        this.adminUser = builder.adminUser;
        this.clientLogging = builder.clientLogging;
        this.idleConnectionTimeout = builder.idleConnectionTimeout;
        this.connectionPoolFactory = builder.connectionPoolFactory;
        this.domainClassNames = Collections.unmodifiableCollection(builder.domainClassNames);
        this.connectionPoolUsers = Collections.unmodifiableCollection(builder.connectionPoolUsers);
        this.clientTypeIdleConnectionTimeouts = Collections.unmodifiableMap(builder.clientTypeIdleConnectionTimeouts);
    }

    public String serverName() {
        return this.serverConfiguration.serverName();
    }

    public int port() {
        return this.serverConfiguration.port();
    }

    public Collection<String> auxiliaryServerFactoryClassNames() {
        return this.serverConfiguration.auxiliaryServerFactoryClassNames();
    }

    public boolean sslEnabled() {
        return this.serverConfiguration.sslEnabled();
    }

    public Optional<RMIClientSocketFactory> rmiClientSocketFactory() {
        return this.serverConfiguration.rmiClientSocketFactory();
    }

    public Optional<RMIServerSocketFactory> rmiServerSocketFactory() {
        return this.serverConfiguration.rmiServerSocketFactory();
    }

    public Optional<String> objectInputFilterFactoryClassName() {
        return this.serverConfiguration.objectInputFilterFactoryClassName();
    }

    public int connectionMaintenanceInterval() {
        return this.serverConfiguration.connectionMaintenanceInterval();
    }

    public int registryPort() {
        return this.serverConfiguration.registryPort();
    }

    public int adminPort() {
        return this.serverConfiguration.adminPort();
    }

    public int connectionLimit() {
        return this.serverConfiguration.connectionLimit();
    }

    @Override
    public Database database() {
        return this.database;
    }

    @Override
    public User adminUser() {
        return this.adminUser;
    }

    @Override
    public boolean clientLogging() {
        return this.clientLogging;
    }

    @Override
    public int idleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    @Override
    public String connectionPoolFactory() {
        return this.connectionPoolFactory;
    }

    @Override
    public Collection<String> domainClassNames() {
        return this.domainClassNames;
    }

    @Override
    public Collection<User> connectionPoolUsers() {
        return this.connectionPoolUsers;
    }

    @Override
    public Map<String, Integer> clientTypeIdleConnectionTimeouts() {
        return this.clientTypeIdleConnectionTimeouts;
    }

    static EntityServerConfiguration.Builder builderFromSystemProperties() {
        User adminUser;
        EntityServerConfiguration.Builder builder = ((EntityServerConfiguration.Builder)((EntityServerConfiguration.Builder)((EntityServerConfiguration.Builder)((EntityServerConfiguration.Builder)new DefaultBuilder((Integer)SERVER_PORT.getOrThrow(), (Integer)REGISTRY_PORT.getOrThrow()).auxiliaryServerFactoryClassNames((Collection)Text.parseCommaSeparatedValues((String)((String)AUXILIARY_SERVER_FACTORY_CLASS_NAMES.get()))).sslEnabled(((Boolean)SSL_ENABLED.get()).booleanValue())).objectInputFilterFactoryClassName((String)OBJECT_INPUT_FILTER_FACTORY_CLASS_NAME.get())).adminPort((Integer)ADMIN_PORT.getOrThrow())).connectionLimit((Integer)CONNECTION_LIMIT.get())).database(Database.instance()).domainClassNames(Text.parseCommaSeparatedValues((String)((String)DOMAIN_MODEL_CLASSES.get()))).connectionPoolUsers(Text.parseCommaSeparatedValues((String)((String)CONNECTION_POOL_USERS.get())).stream().map(User::parse).collect(Collectors.toList())).clientLogging((Boolean)CLIENT_LOGGING.get()).idleConnectionTimeout((Integer)IDLE_CONNECTION_TIMEOUT.get());
        HashMap<String, Integer> clientTypeIdleConnectionTimeoutMap = new HashMap<String, Integer>();
        for (String clientTimeout : Text.parseCommaSeparatedValues((String)((String)CLIENT_CONNECTION_TIMEOUT.get()))) {
            String[] split = clientTimeout.split(":");
            if (split.length < 2) {
                throw new IllegalArgumentException("Expecting a ':' delimiter");
            }
            clientTypeIdleConnectionTimeoutMap.put(split[0], Integer.parseInt(split[1]));
        }
        builder.clientTypeIdleConnectionTimeouts(clientTypeIdleConnectionTimeoutMap);
        String adminUserString = (String)ADMIN_USER.get();
        User user = adminUser = Text.nullOrEmpty((String)adminUserString) ? null : User.parse((String)adminUserString);
        if (adminUser == null) {
            LOG.info("No admin user specified");
        } else {
            LOG.info("Admin user: {}", (Object)adminUser);
            builder.adminUser(adminUser);
        }
        return builder;
    }

    static final class DefaultBuilder
    implements EntityServerConfiguration.Builder {
        private final ServerConfiguration.Builder<?> serverConfigurationBuilder;
        private Database database;
        private User adminUser;
        private boolean clientLogging = (Boolean)EntityServerConfiguration.CLIENT_LOGGING.get();
        private int idleConnectionTimeout = (Integer)ServerConfiguration.IDLE_CONNECTION_TIMEOUT.get();
        private String connectionPoolFactory;
        private final Collection<String> domainClassNames = new HashSet<String>();
        private final Collection<User> connectionPoolUsers = new HashSet<User>();
        private final Map<String, Integer> clientTypeIdleConnectionTimeouts = new HashMap<String, Integer>();

        DefaultBuilder(int serverPort, int registryPort) {
            this.serverConfigurationBuilder = ServerConfiguration.builder((int)serverPort, (int)registryPort);
            this.serverConfigurationBuilder.serverName(() -> {
                if (this.database == null) {
                    throw new IllegalStateException("Database must be set before initializing server name");
                }
                return (String)ServerConfiguration.SERVER_NAME_PREFIX.get() + " " + Version.versionString() + "@" + this.database.name().toUpperCase();
            });
        }

        public EntityServerConfiguration.Builder serverName(Supplier<String> serverNameSupplier) {
            this.serverConfigurationBuilder.serverName(serverNameSupplier);
            return this;
        }

        public EntityServerConfiguration.Builder serverName(String serverName) {
            this.serverConfigurationBuilder.serverName(serverName);
            return this;
        }

        public EntityServerConfiguration.Builder auxiliaryServerFactoryClassNames(Collection<String> auxiliaryServerFactoryClassNames) {
            this.serverConfigurationBuilder.auxiliaryServerFactoryClassNames(auxiliaryServerFactoryClassNames);
            return this;
        }

        public EntityServerConfiguration.Builder sslEnabled(boolean sslEnabled) {
            this.serverConfigurationBuilder.sslEnabled(sslEnabled);
            return this;
        }

        public EntityServerConfiguration.Builder rmiClientSocketFactory(RMIClientSocketFactory rmiClientSocketFactory) {
            this.serverConfigurationBuilder.rmiClientSocketFactory(rmiClientSocketFactory);
            return this;
        }

        public EntityServerConfiguration.Builder rmiServerSocketFactory(RMIServerSocketFactory rmiServerSocketFactory) {
            this.serverConfigurationBuilder.rmiServerSocketFactory(rmiServerSocketFactory);
            return this;
        }

        public EntityServerConfiguration.Builder objectInputFilterFactoryClassName(String objectInputFilterFactoryClassName) {
            this.serverConfigurationBuilder.objectInputFilterFactoryClassName(objectInputFilterFactoryClassName);
            return this;
        }

        public EntityServerConfiguration.Builder connectionMaintenanceInterval(int connectionMaintenanceInterval) {
            this.serverConfigurationBuilder.connectionMaintenanceInterval(connectionMaintenanceInterval);
            return this;
        }

        public EntityServerConfiguration.Builder adminPort(int adminPort) {
            this.serverConfigurationBuilder.adminPort(adminPort);
            return this;
        }

        public EntityServerConfiguration.Builder connectionLimit(int connectionLimit) {
            this.serverConfigurationBuilder.connectionLimit(connectionLimit);
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder database(Database database) {
            this.database = Objects.requireNonNull(database);
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder adminUser(User adminUser) {
            this.adminUser = Objects.requireNonNull(adminUser);
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder clientLogging(boolean clientLogging) {
            this.clientLogging = clientLogging;
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder idleConnectionTimeout(int idleConnectionTimeout) {
            this.idleConnectionTimeout = idleConnectionTimeout;
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder connectionPoolFactory(String connectionPoolFactory) {
            this.connectionPoolFactory = Objects.requireNonNull(connectionPoolFactory);
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder domainClassNames(Collection<String> domainClassNames) {
            this.domainClassNames.addAll(Objects.requireNonNull(domainClassNames));
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder connectionPoolUsers(Collection<User> connectionPoolUsers) {
            this.connectionPoolUsers.addAll(Objects.requireNonNull(connectionPoolUsers));
            return this;
        }

        @Override
        public EntityServerConfiguration.Builder clientTypeIdleConnectionTimeouts(Map<String, Integer> clientTypeIdleConnectionTimeouts) {
            this.clientTypeIdleConnectionTimeouts.putAll(Objects.requireNonNull(clientTypeIdleConnectionTimeouts));
            return this;
        }

        @Override
        public EntityServerConfiguration build() {
            return new DefaultEntityServerConfiguration(this);
        }
    }
}

