/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.Configuration;
import is.codion.common.db.database.Database;
import is.codion.common.property.PropertyValue;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.user.User;
import is.codion.framework.server.DefaultEntityServerConfiguration;
import java.util.Collection;
import java.util.Map;

public interface EntityServerConfiguration
extends ServerConfiguration {
    public static final PropertyValue<Integer> CONNECTION_LIMIT = Configuration.integerValue((String)"codion.server.connectionLimit", (int)-1);
    public static final PropertyValue<String> CONNECTION_POOL_FACTORY_CLASS = Configuration.stringValue((String)"codion.server.pooling.poolFactoryClass");
    public static final PropertyValue<String> CLIENT_CONNECTION_TIMEOUT = Configuration.stringValue((String)"codion.server.clientConnectionTimeout");
    public static final PropertyValue<Boolean> CLIENT_LOGGING = Configuration.booleanValue((String)"codion.server.clientLogging", (boolean)false);
    public static final PropertyValue<String> CONNECTION_POOL_USERS = Configuration.stringValue((String)"codion.server.connectionPoolUsers");
    public static final PropertyValue<String> DOMAIN_MODEL_CLASSES = Configuration.stringValue((String)"codion.server.domain.classes");

    public Database database();

    public User adminUser();

    public boolean clientLogging();

    public int idleConnectionTimeout();

    public String connectionPoolFactory();

    public Collection<String> domainClassNames();

    public Collection<User> connectionPoolUsers();

    public Map<String, Integer> clientTypeIdleConnectionTimeouts();

    public static Builder builder(int serverPort, int registryPort) {
        return new DefaultEntityServerConfiguration.DefaultBuilder(serverPort, registryPort);
    }

    public static Builder builderFromSystemProperties() {
        return DefaultEntityServerConfiguration.builderFromSystemProperties();
    }

    public static interface Builder
    extends ServerConfiguration.Builder<Builder> {
        public Builder database(Database var1);

        public Builder adminUser(User var1);

        public Builder clientLogging(boolean var1);

        public Builder idleConnectionTimeout(int var1);

        public Builder connectionPoolFactory(String var1);

        public Builder domainClassNames(Collection<String> var1);

        public Builder connectionPoolUsers(Collection<User> var1);

        public Builder clientTypeIdleConnectionTimeouts(Map<String, Integer> var1);

        public EntityServerConfiguration build();
    }
}

