/*
 * Decompiled with CFR 0.152.
 */
package it.mauxilium.arduinojavaserialrpc;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import it.mauxilium.arduinojavaserialrpc.businesslogic.UsbHandler;
import it.mauxilium.arduinojavaserialrpc.exception.ArduinoRpcInitializationError;
import it.mauxilium.arduinojavaserialrpc.exception.ArduinoRpcJavaFailsException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TooManyListenersException;
import java.util.logging.Logger;

public class ArduinoJavaSerialRpc {
    public static final String MAC_OS_DEFAULT_PORT = "/dev/tty.usbserial-A9007UX1";
    public static final String RASPBERRY_PI_DEFAULT_PORT = "/dev/ttyACM0";
    public static final String LINUX_DEFAULT_PORT = "/dev/ttyUSB0";
    public static final String WINDOWS_DEFAULT_PORT = "COM5";
    public static final String WINDOWS_USB_1 = "COM1";
    public static final String WINDOWS_USB_2 = "COM2";
    public static final String WINDOWS_USB_3 = "COM3";
    public static final String WINDOWS_USB_4 = "COM4";
    public static final String WINDOWS_USB_5 = "COM5";
    public static final String WINDOWS_USB_6 = "COM6";
    public static final int DATA_RATE_300 = 300;
    public static final int DATA_RATE_600 = 600;
    public static final int DATA_RATE_1200 = 1200;
    public static final int DATA_RATE_2400 = 2400;
    public static final int DATA_RATE_4800 = 4800;
    public static final int DATA_RATE_9600 = 9600;
    public static final int DATA_RATE_14400 = 14400;
    public static final int DATA_RATE_19200 = 19200;
    public static final int DATA_RATE_28800 = 28800;
    public static final int DATA_RATE_38400 = 38400;
    public static final int DATA_RATE_57600 = 57600;
    public static final int DATA_RATE_115200 = 115200;
    private final UsbHandler usbHandler;

    public ArduinoJavaSerialRpc(String string, int n) {
        this.usbHandler = new UsbHandler(string, n);
    }

    public void connect() throws ArduinoRpcInitializationError {
        try {
            this.usbHandler.initialize(this);
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException | TooManyListenersException throwable) {
            throw new ArduinoRpcInitializationError((Exception)throwable);
        }
    }

    public void disconnect() throws IOException {
        this.usbHandler.disconnect();
    }

    public static String[] portScanner() {
        return UsbHandler.portScanner();
    }

    public String getPortName() {
        return this.usbHandler.getPortName();
    }

    public int getBaudRate() {
        return this.usbHandler.getBaudRate();
    }

    public String getCardName() throws ArduinoRpcJavaFailsException {
        return this.usbHandler.getCardName();
    }

    public void executeRemoteFunction(String string) throws ArduinoRpcJavaFailsException {
        this.usbHandler.executeFunction(string);
    }

    public Integer executeRemoteFunction(String string, int n, int n2) throws ArduinoRpcJavaFailsException {
        return this.usbHandler.executeFunction(string, n, n2);
    }

    public String executeRemoteFunction(String string, String string2) throws ArduinoRpcJavaFailsException {
        return this.usbHandler.executeFunction(string, string2);
    }

    public float executeRemoteFunction(String string, float f) throws ArduinoRpcJavaFailsException {
        return this.usbHandler.executeFunction(string, f);
    }

    public void handlerReceivingException(Exception exception) {
        System.err.println("Error handling Arduino message: " + exception.toString());
    }

    public void executeLocalMethod(String string) throws ArduinoRpcJavaFailsException {
        Method method;
        try {
            method = this.getClass().getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
    }

    public void executeLocalMethod(String string, int n, int n2) throws ArduinoRpcJavaFailsException {
        Method method;
        try {
            method = this.getClass().getMethod(string, Integer.class, Integer.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
        try {
            method.invoke((Object)this, n, n2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
    }

    public void executeLocalMethod(String string, String string2) throws ArduinoRpcJavaFailsException {
        Method method;
        try {
            method = this.getClass().getMethod(string, String.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
        try {
            method.invoke((Object)this, string2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
    }

    public void executeLocalMethod(String string, float f) throws ArduinoRpcJavaFailsException {
        Method method;
        try {
            method = this.getClass().getMethod(string, Float.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
        try {
            method.invoke((Object)this, Float.valueOf(f));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new ArduinoRpcJavaFailsException(exception);
        }
    }

    static {
        System.out.println("Powered by ArduinoJavaSerialRpc from www.mauxilium.it");
        Logger.getGlobal().info("Powered by ArduinoJavaSerialRpc from www.mauxilium.it");
    }
}

