/*
 * Decompiled with CFR 0.152.
 */
package it.mauxilium.arduinojavaserialrpc.businesslogic;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import it.mauxilium.arduinojavaserialrpc.ArduinoJavaSerialRpc;
import it.mauxilium.arduinojavaserialrpc.businesslogic.ProtocolToArduino;
import it.mauxilium.arduinojavaserialrpc.businesslogic.UsbReceiverAgent;
import it.mauxilium.arduinojavaserialrpc.exception.ArduinoRpcJavaFailsException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.concurrent.Semaphore;

public class UsbHandler {
    public static final char VOID_ARG_PREAMBLE = 'V';
    public static final char INT_ARG_PREAMBLE = 'I';
    public static final char INT_INT_ARG_PREAMBLE = 'H';
    public static final char STRING_ARG_PREAMBLE = 'S';
    public static final char FLOAT_ARG_PREAMBLE = 'F';
    SerialPort serialPort;
    private static final String[] PORT_NAMES = new String[]{"/dev/tty.usbserial-A9007UX1", "/dev/ttyACM0", "/dev/ttyUSB0", "COM4"};
    private BufferedReader input;
    private OutputStream output;
    private static final int TIME_OUT = 20000;
    private final String selectedPortName;
    private final int selectedBaudRate;
    private Object callingResult;
    private final Semaphore callingLock = new Semaphore(1, true);
    private final Object waitingResultLock = new Object();

    public UsbHandler(String string, int n) {
        this.selectedPortName = string;
        this.selectedBaudRate = n;
    }

    public void initialize(ArduinoJavaSerialRpc arduinoJavaSerialRpc) throws PortInUseException, UnsupportedCommOperationException, IOException, TooManyListenersException, NoSuchPortException {
        CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.selectedPortName);
        if (commPortIdentifier.isCurrentlyOwned()) {
            throw new PortInUseException();
        }
        this.serialPort = (SerialPort)commPortIdentifier.open(this.getClass().getName(), 20000);
        this.serialPort.setSerialPortParams(this.selectedBaudRate, 8, 1, 0);
        this.input = new BufferedReader(new InputStreamReader(this.serialPort.getInputStream()));
        this.output = this.serialPort.getOutputStream();
        UsbReceiverAgent usbReceiverAgent = new UsbReceiverAgent(this, this.input, arduinoJavaSerialRpc);
        this.serialPort.addEventListener((SerialPortEventListener)usbReceiverAgent);
        this.serialPort.notifyOnDataAvailable(true);
        usbReceiverAgent.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getPortName() {
        return this.selectedPortName;
    }

    public int getBaudRate() {
        return this.selectedBaudRate;
    }

    public void disconnect() throws IOException {
        this.input.close();
        this.output.close();
        this.serialPort.removeEventListener();
        this.serialPort.close();
    }

    public static String[] portScanner() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            arrayList.add(stringArray.getName() + " (" + stringArray.getPortType() + "): owner: " + stringArray.getCurrentOwner());
        }
        stringArray = new String[arrayList.size()];
        int n = 0;
        for (String string : arrayList) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public synchronized void close() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCardName() throws ArduinoRpcJavaFailsException {
        this.checkConnectionReady();
        this.callingLock();
        Object object = this.waitingResultLock;
        synchronized (object) {
            try {
                ProtocolToArduino.sendCommand("GetCardName", "", this.output);
            }
            catch (IOException iOException) {
                this.callingRelease();
                throw new ArduinoRpcJavaFailsException("Executing get card name", iOException);
            }
            this.waitResult();
        }
        this.callingRelease();
        return (String)this.callingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFunction(String string) throws ArduinoRpcJavaFailsException {
        this.checkConnectionReady();
        this.callingLock();
        Object object = this.waitingResultLock;
        synchronized (object) {
            try {
                ProtocolToArduino.sendCommand(string, this.output);
            }
            catch (IOException iOException) {
                this.callingRelease();
                throw new ArduinoRpcJavaFailsException("Executing " + string, iOException);
            }
            this.waitResult();
        }
        this.callingRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeFunction(String string, int n, int n2) throws ArduinoRpcJavaFailsException {
        this.checkConnectionReady();
        this.callingLock();
        Object object = this.waitingResultLock;
        synchronized (object) {
            try {
                ProtocolToArduino.sendCommand(string, n, n2, this.output);
            }
            catch (IOException iOException) {
                this.callingRelease();
                throw new ArduinoRpcJavaFailsException("Executing " + string + "(" + n + "," + n2 + ")", iOException);
            }
            this.waitResult();
        }
        this.callingRelease();
        return (Integer)this.callingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeFunction(String string, String string2) throws ArduinoRpcJavaFailsException {
        this.checkConnectionReady();
        this.callingLock();
        Object object = this.waitingResultLock;
        synchronized (object) {
            try {
                ProtocolToArduino.sendCommand(string, string2, this.output);
            }
            catch (IOException iOException) {
                this.callingRelease();
                throw new ArduinoRpcJavaFailsException("Executing " + string + "(" + string2 + ")", iOException);
            }
            this.waitResult();
        }
        this.callingRelease();
        return (String)this.callingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float executeFunction(String string, float f) throws ArduinoRpcJavaFailsException {
        this.checkConnectionReady();
        this.callingLock();
        Object object = this.waitingResultLock;
        synchronized (object) {
            try {
                ProtocolToArduino.sendCommand(string, f, this.output);
            }
            catch (IOException iOException) {
                this.callingRelease();
                throw new ArduinoRpcJavaFailsException("Executing " + string + "(" + f + ")", iOException);
            }
            this.waitResult();
        }
        this.callingRelease();
        return ((Float)this.callingResult).floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncomingResult(Object object) {
        this.callingResult = object;
        Object object2 = this.waitingResultLock;
        synchronized (object2) {
            this.waitingResultLock.notifyAll();
        }
    }

    private void checkConnectionReady() throws ArduinoRpcJavaFailsException {
        if (this.output == null) {
            throw new ArduinoRpcJavaFailsException("Arduino is not connected. Please use connect() before to perform Arduino activities.");
        }
    }

    private void callingLock() throws ArduinoRpcJavaFailsException {
        try {
            this.callingLock.acquire();
        }
        catch (InterruptedException interruptedException) {
            throw new ArduinoRpcJavaFailsException("Reserving priority in calling Arduino function", interruptedException);
        }
    }

    private void waitResult() throws ArduinoRpcJavaFailsException {
        try {
            this.waitingResultLock.wait();
        }
        catch (InterruptedException interruptedException) {
            throw new ArduinoRpcJavaFailsException("Waiting result from called Arduino function", interruptedException);
        }
    }

    private void callingRelease() {
        this.callingLock.release();
    }
}

