/*
 * Decompiled with CFR 0.152.
 */
package it.mauxilium.arduinojavaserialrpc.businesslogic;

import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import it.mauxilium.arduinojavaserialrpc.ArduinoJavaSerialRpc;
import it.mauxilium.arduinojavaserialrpc.businesslogic.ProtocolFromArduino;
import it.mauxilium.arduinojavaserialrpc.businesslogic.UsbHandler;
import it.mauxilium.arduinojavaserialrpc.exception.ArduinoRpcCardException;
import it.mauxilium.arduinojavaserialrpc.exception.ArduinoRpcJavaFailsException;
import java.io.BufferedReader;
import java.io.IOException;

class UsbReceiverAgent
extends Thread
implements SerialPortEventListener {
    private static final String CMD_PREAMBLE = "MArC_cmd";
    private static final String RESULT_PREAMBLE = "MArC_res";
    private static final String ERROR_PREAMBLE = "MArC_err";
    private static final String MESSAGE_PREAMBLE = "MArC_msg";
    private final UsbHandler usbH;
    private final BufferedReader input;
    private final ArduinoJavaSerialRpc controller;
    private Object callingResult;
    private final Object receiverWaitingResultLock = new Object();

    public UsbReceiverAgent(UsbHandler usbHandler, BufferedReader bufferedReader, ArduinoJavaSerialRpc arduinoJavaSerialRpc) {
        this.usbH = usbHandler;
        this.input = bufferedReader;
        this.controller = arduinoJavaSerialRpc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent serialPortEvent) {
        block9: {
            if (serialPortEvent.getEventType() == 1) {
                try {
                    this.handleReceivingData();
                }
                catch (ArduinoRpcCardException | ArduinoRpcJavaFailsException | IOException exception) {
                    if (!"Underlying input stream returned zero bytes".equals(exception.getMessage())) {
                        this.controller.handlerReceivingException(exception);
                        this.callingResult = null;
                        Object object = this.receiverWaitingResultLock;
                        synchronized (object) {
                            this.receiverWaitingResultLock.notifyAll();
                            break block9;
                        }
                    }
                    System.out.println("Serial event exception: " + exception.toString());
                }
            } else assert (serialPortEvent.getEventType() == 2) : "Serial Output buffer empty";
        }
    }

    private void handleReceivingData() throws IOException, ArduinoRpcJavaFailsException, ArduinoRpcCardException {
        if (this.input.ready()) {
            String string;
            switch (string = this.input.readLine()) {
                case "MArC_cmd": {
                    ProtocolFromArduino.receiveCommand(this.input, this.controller);
                    break;
                }
                case "MArC_res": {
                    this.parsingResult();
                    break;
                }
                case "MArC_err": {
                    throw new ArduinoRpcCardException(this.input.readLine());
                }
                case "MArC_msg": {
                    System.out.println("Arduino message: " + this.input.readLine());
                    break;
                }
                default: {
                    if (string.isEmpty()) break;
                    System.out.println("Ignoring fragmented command: " + string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parsingResult() throws IOException {
        String string = this.input.readLine();
        switch (string.charAt(0)) {
            case 'V': {
                this.callingResult = null;
                break;
            }
            case 'I': {
                this.callingResult = Integer.parseInt(this.input.readLine());
                break;
            }
            case 'F': {
                this.callingResult = Float.valueOf(Float.parseFloat(this.input.readLine()));
                break;
            }
            case 'S': {
                this.callingResult = this.input.readLine();
                break;
            }
            default: {
                throw new IOException("Not supported received data type: " + string);
            }
        }
        Object object = this.receiverWaitingResultLock;
        synchronized (object) {
            this.receiverWaitingResultLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object = this.receiverWaitingResultLock;
            synchronized (object) {
                try {
                    this.receiverWaitingResultLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.usbH.setIncomingResult(this.callingResult);
        }
    }
}

