/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import me.cryptopay.model.Callback;
import me.cryptopay.model.ChannelPaymentCallback;
import me.cryptopay.model.CoinWithdrawalCallback;
import me.cryptopay.model.InvoiceCallback;

public class JSON {
    private final Gson gson;

    public JSON() {
        OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.gson = JSON.createGson().registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter).create();
    }

    private static GsonBuilder createGson() {
        GsonFireBuilder builder = new GsonFireBuilder();
        builder.registerTypeSelector(Callback.class, (TypeSelector)new TypeSelector<Callback>(){

            public Class<? extends Callback> getClassForElement(JsonElement readElement) {
                String discriminator;
                JsonElement el = readElement.getAsJsonObject().get("type");
                if (el == null) {
                    throw new IllegalArgumentException("missing discriminator field: <type>");
                }
                switch (discriminator = el.getAsString()) {
                    case "ChannelPayment": {
                        return ChannelPaymentCallback.class;
                    }
                    case "ChannelPaymentCallback": {
                        return ChannelPaymentCallback.class;
                    }
                    case "CoinWithdrawal": {
                        return CoinWithdrawalCallback.class;
                    }
                    case "CoinWithdrawalCallback": {
                        return CoinWithdrawalCallback.class;
                    }
                    case "Invoice": {
                        return InvoiceCallback.class;
                    }
                    case "InvoiceCallback": {
                        return InvoiceCallback.class;
                    }
                }
                throw new IllegalArgumentException("cannot determine model class of name: <" + discriminator + ">");
            }
        });
        return builder.createGsonBuilder();
    }

    public String serialize(Object obj) {
        return this.gson.toJson(obj);
    }

    public <T> T deserialize(String body, Class<T> returnType) {
        return (T)this.gson.fromJson(body, returnType);
    }

    private static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private static final String ZERO_OFFSET = "+0000";
        private DateTimeFormatter formatter;

        OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            Object date = in.nextString();
            if (((String)date).endsWith(ZERO_OFFSET)) {
                date = ((String)date).substring(0, ((String)date).length() - ZERO_OFFSET.length()) + "Z";
            }
            return OffsetDateTime.parse((CharSequence)date, this.formatter);
        }
    }
}

