/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.util.UUID;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.CoinWithdrawalListResult;
import me.cryptopay.model.CoinWithdrawalParams;
import me.cryptopay.model.CoinWithdrawalResult;
import me.cryptopay.model.NetworkFeeListResult;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class CoinWithdrawals {
    private final ApiClient apiClient;

    public CoinWithdrawals(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CommitCall commit(UUID coinWithdrawalId) {
        return new CommitCall(coinWithdrawalId);
    }

    public CreateCall create(CoinWithdrawalParams coinWithdrawalParams) {
        return new CreateCall(coinWithdrawalParams);
    }

    public ListCall list() {
        return new ListCall();
    }

    public ListNetworkFeesCall listNetworkFees() {
        return new ListNetworkFeesCall();
    }

    public RetrieveCall retrieve(UUID coinWithdrawalId) {
        return new RetrieveCall(coinWithdrawalId);
    }

    public RetrieveByCustomIdCall retrieveByCustomId(String customId) {
        return new RetrieveByCustomIdCall(customId);
    }

    public final class RetrieveByCustomIdCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/coin_withdrawals/custom_id/{custom_id}");

        private RetrieveByCustomIdCall(String customId) {
            this.request.addPathParam("custom_id", customId.toString());
        }

        public CoinWithdrawalResult execute() throws ApiException {
            return CoinWithdrawals.this.apiClient.execute(this.request, CoinWithdrawalResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/coin_withdrawals/{coin_withdrawal_id}");

        private RetrieveCall(UUID coinWithdrawalId) {
            this.request.addPathParam("coin_withdrawal_id", coinWithdrawalId.toString());
        }

        public CoinWithdrawalResult execute() throws ApiException {
            return CoinWithdrawals.this.apiClient.execute(this.request, CoinWithdrawalResult.class);
        }
    }

    public final class ListNetworkFeesCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/coin_withdrawals/network_fees");

        private ListNetworkFeesCall() {
        }

        public ListNetworkFeesCall allNetworks(Boolean allNetworks) {
            this.request.addQueryParam("all_networks", allNetworks.toString());
            return this;
        }

        public NetworkFeeListResult execute() throws ApiException {
            return CoinWithdrawals.this.apiClient.execute(this.request, NetworkFeeListResult.class);
        }
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/coin_withdrawals");

        private ListCall() {
        }

        public ListCall customerId(String customerId) {
            this.request.addQueryParam("customer_id", customerId.toString());
            return this;
        }

        public ListCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public CoinWithdrawalListResult execute() throws ApiException {
            return CoinWithdrawals.this.apiClient.execute(this.request, CoinWithdrawalListResult.class);
        }
    }

    public final class CreateCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/coin_withdrawals");

        private CreateCall(CoinWithdrawalParams coinWithdrawalParams) {
            this.request.setBody(coinWithdrawalParams);
        }

        public CoinWithdrawalResult execute() throws ApiException {
            return CoinWithdrawals.this.apiClient.execute(this.request, CoinWithdrawalResult.class);
        }
    }

    public final class CommitCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/coin_withdrawals/{coin_withdrawal_id}/commit");

        private CommitCall(UUID coinWithdrawalId) {
            this.request.addPathParam("coin_withdrawal_id", coinWithdrawalId.toString());
        }

        public CoinWithdrawalResult execute() throws ApiException {
            return CoinWithdrawals.this.apiClient.execute(this.request, CoinWithdrawalResult.class);
        }
    }
}

