/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.util.UUID;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.InvoiceListResult;
import me.cryptopay.model.InvoiceParams;
import me.cryptopay.model.InvoiceRecalculationParams;
import me.cryptopay.model.InvoiceRecalculationResult;
import me.cryptopay.model.InvoiceRefundListResult;
import me.cryptopay.model.InvoiceRefundParams;
import me.cryptopay.model.InvoiceRefundResult;
import me.cryptopay.model.InvoiceResult;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Invoices {
    private final ApiClient apiClient;

    public Invoices(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CommitRecalculationCall commitRecalculation(UUID invoiceId, UUID recalculationId) {
        return new CommitRecalculationCall(invoiceId, recalculationId);
    }

    public CreateCall create(InvoiceParams invoiceParams) {
        return new CreateCall(invoiceParams);
    }

    public CreateRecalculationCall createRecalculation(UUID invoiceId, InvoiceRecalculationParams invoiceRecalculationParams) {
        return new CreateRecalculationCall(invoiceId, invoiceRecalculationParams);
    }

    public CreateRefundCall createRefund(UUID invoiceId, InvoiceRefundParams invoiceRefundParams) {
        return new CreateRefundCall(invoiceId, invoiceRefundParams);
    }

    public ListCall list() {
        return new ListCall();
    }

    public ListRefundsCall listRefunds(UUID invoiceId) {
        return new ListRefundsCall(invoiceId);
    }

    public RetrieveCall retrieve(UUID invoiceId) {
        return new RetrieveCall(invoiceId);
    }

    public RetrieveByCustomIdCall retrieveByCustomId(String customId) {
        return new RetrieveByCustomIdCall(customId);
    }

    public final class RetrieveByCustomIdCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/invoices/custom_id/{custom_id}");

        private RetrieveByCustomIdCall(String customId) {
            this.request.addPathParam("custom_id", customId.toString());
        }

        public InvoiceResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/invoices/{invoice_id}");

        private RetrieveCall(UUID invoiceId) {
            this.request.addPathParam("invoice_id", invoiceId.toString());
        }

        public InvoiceResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceResult.class);
        }
    }

    public final class ListRefundsCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/invoices/{invoice_id}/refunds");

        private ListRefundsCall(UUID invoiceId) {
            this.request.addPathParam("invoice_id", invoiceId.toString());
        }

        public InvoiceRefundListResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceRefundListResult.class);
        }
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/invoices");

        private ListCall() {
        }

        public ListCall customerId(String customerId) {
            this.request.addQueryParam("customer_id", customerId.toString());
            return this;
        }

        public ListCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public InvoiceListResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceListResult.class);
        }
    }

    public final class CreateRefundCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/invoices/{invoice_id}/refunds");

        private CreateRefundCall(UUID invoiceId, InvoiceRefundParams invoiceRefundParams) {
            this.request.addPathParam("invoice_id", invoiceId.toString());
            this.request.setBody(invoiceRefundParams);
        }

        public InvoiceRefundResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceRefundResult.class);
        }
    }

    public final class CreateRecalculationCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/invoices/{invoice_id}/recalculations");

        private CreateRecalculationCall(UUID invoiceId, InvoiceRecalculationParams invoiceRecalculationParams) {
            this.request.addPathParam("invoice_id", invoiceId.toString());
            this.request.setBody(invoiceRecalculationParams);
        }

        public InvoiceRecalculationResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceRecalculationResult.class);
        }
    }

    public final class CreateCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/invoices");

        private CreateCall(InvoiceParams invoiceParams) {
            this.request.setBody(invoiceParams);
        }

        public InvoiceResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceResult.class);
        }
    }

    public final class CommitRecalculationCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/invoices/{invoice_id}/recalculations/{recalculation_id}/commit");

        private CommitRecalculationCall(UUID invoiceId, UUID recalculationId) {
            this.request.addPathParam("invoice_id", invoiceId.toString());
            this.request.addPathParam("recalculation_id", recalculationId.toString());
        }

        public InvoiceRecalculationResult execute() throws ApiException {
            return Invoices.this.apiClient.execute(this.request, InvoiceRecalculationResult.class);
        }
    }
}

