/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public final class ApiRequest {
    private Object body;
    private final String method;
    private final String path;
    private final Map<String, String> pathParams;
    private final Map<String, String> queryParams;

    public ApiRequest(String method, String path) {
        this.method = method;
        this.path = path;
        this.pathParams = new HashMap<String, String>();
        this.queryParams = new HashMap<String, String>();
    }

    public String getMethod() {
        return this.method;
    }

    public void setBody(Object value) {
        this.body = value;
    }

    public Object getBody() {
        return this.body;
    }

    public void addQueryParam(String key, String value) {
        this.queryParams.put(this.escapeString(key), this.escapeString(value));
    }

    public void addPathParam(String key, String value) {
        this.pathParams.put(key, this.escapeString(value));
    }

    public String buildUrl(String baseUrl) {
        StringBuilder url = new StringBuilder();
        url.append(baseUrl);
        String fullPath = this.path;
        for (Map.Entry<String, String> param : this.pathParams.entrySet()) {
            fullPath = fullPath.replaceAll("\\{" + param.getKey() + "\\}", param.getValue());
        }
        url.append(fullPath);
        if (!this.queryParams.isEmpty()) {
            String prefix = "?";
            for (Map.Entry<String, String> param : this.queryParams.entrySet()) {
                url.append(prefix);
                url.append(param.getKey());
                url.append("=");
                url.append(param.getValue());
                prefix = "&";
            }
        }
        return url.toString();
    }

    private String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }
}

