/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.cryptopay.util.StringUtils;

public final class HmacEncoder {
    private static final String SHA1 = "HmacSHA1";
    private static final String SHA256 = "HmacSHA256";
    private static final int HEX_RADIX = 16;
    private static final char MAX_HEX = '\u000f';
    private static final int HALF_BYTE_BITS = 4;

    private HmacEncoder() {
    }

    public static String encodeRequest(Data data) throws Exception {
        String bodyMD5 = StringUtils.isEmpty(data.body) ? "" : HmacEncoder.md5hex(data.body);
        String stringToSign = String.join((CharSequence)"\n", data.method, bodyMD5, data.contentType, data.date, data.path);
        return Base64.getEncoder().encodeToString(HmacEncoder.hmac(stringToSign, data.secret, SHA1));
    }

    public static String encodeStr(String str, String secret) throws Exception {
        return HmacEncoder.hex(HmacEncoder.hmac(str, secret, SHA256));
    }

    private static byte[] hmac(String str, String secret, String algorithm) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKey);
        return mac.doFinal(str.getBytes(StandardCharsets.UTF_8));
    }

    private static String md5hex(String str) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] bytes = md5.digest(str.getBytes(StandardCharsets.UTF_8));
        return HmacEncoder.hex(bytes);
    }

    private static String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(HmacEncoder.byteToHex(b));
        }
        return sb.toString();
    }

    private static char[] byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return hexDigits;
    }

    public static class Data {
        private String secret;
        private String method;
        private String body;
        private String date;
        private String path;
        private String contentType;

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }
}

