/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.util.UUID;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.AccountListResult;
import me.cryptopay.model.TransactionListResult;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Accounts {
    private final ApiClient apiClient;

    public Accounts(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ListCall list() {
        return new ListCall();
    }

    public ListTransactionsCall listTransactions(UUID accountId) {
        return new ListTransactionsCall(accountId);
    }

    public final class ListTransactionsCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/accounts/{account_id}/transactions");

        private ListTransactionsCall(UUID accountId) {
            this.request.addPathParam("account_id", accountId.toString());
        }

        public ListTransactionsCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public TransactionListResult execute() throws ApiException {
            return Accounts.this.apiClient.execute(this.request, TransactionListResult.class);
        }
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/accounts");

        private ListCall() {
        }

        public AccountListResult execute() throws ApiException {
            return Accounts.this.apiClient.execute(this.request, AccountListResult.class);
        }
    }
}

