/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.net;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import me.cryptopay.JSON;
import me.cryptopay.exception.ApiException;
import me.cryptopay.net.ApiRequest;
import me.cryptopay.net.Authentication;
import me.cryptopay.util.StringUtils;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okhttp3.logging.HttpLoggingInterceptor;

public class ApiClient {
    private static final String CONTENT_TYPE = "application/json";
    private final Authentication authentication;
    private final JSON json;
    private final OkHttpClient httpClient;
    private final String baseUrl;
    private final String userAgent;

    public ApiClient(String baseUrl, Authentication authentication, JSON json, boolean debug, String userAgent) {
        this.baseUrl = baseUrl;
        this.authentication = authentication;
        this.json = json;
        this.userAgent = userAgent;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (debug) {
            HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
            httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)httpLoggingInterceptor);
        }
        this.httpClient = builder.build();
    }

    public void execute(ApiRequest apiRequest) throws ApiException {
        this.execute(apiRequest, null);
    }

    public <T> T execute(ApiRequest apiRequest, Class<T> returnType) throws ApiException {
        String url = apiRequest.buildUrl(this.baseUrl);
        String content = this.buildRequestContent(apiRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", CONTENT_TYPE);
        headers.put("User-Agent", this.userAgent);
        this.authentication.apply(apiRequest.getMethod(), URI.create(url), content, headers);
        RequestBody reqBody = null;
        if (content != null) {
            reqBody = RequestBody.create((byte[])content.getBytes());
        }
        Request.Builder reqBuilder = new Request.Builder().url(url).method(apiRequest.getMethod(), reqBody);
        for (Map.Entry param : headers.entrySet()) {
            reqBuilder.header((String)param.getKey(), (String)param.getValue());
        }
        Call call = this.httpClient.newCall(reqBuilder.build());
        return this.execute(call, returnType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Call call, Class<T> returnType) throws ApiException {
        try (Response response = call.execute();){
            T t = this.handleResponse(response, returnType);
            return t;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private String buildRequestContent(ApiRequest apiRequest) {
        if (!HttpMethod.permitsRequestBody((String)apiRequest.getMethod())) {
            return null;
        }
        if (apiRequest.getBody() == null) {
            return "";
        }
        return this.json.serialize(apiRequest.getBody());
    }

    private <T> T handleResponse(Response response, Class<T> returnType) throws ApiException, IOException {
        String respBody;
        String string = respBody = response.body() == null ? null : response.body().string();
        if (!response.isSuccessful()) {
            throw new ApiException(response.request().method(), response.request().url().toString(), response.code(), respBody);
        }
        if (returnType == null || StringUtils.isEmpty(respBody)) {
            return null;
        }
        return this.json.deserialize(respBody, returnType);
    }
}

