/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.net;

import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import me.cryptopay.exception.ApiException;
import me.cryptopay.security.HmacEncoder;
import me.cryptopay.util.StringUtils;

public class Authentication {
    private static final String SCHEME = "HMAC";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME;
    private final String apiKey;
    private final String apiSecret;

    public Authentication(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public void apply(String method, URI uri, String body, Map<String, String> headers) throws ApiException {
        String signature;
        HmacEncoder.Data data = new HmacEncoder.Data();
        data.setSecret(this.apiSecret);
        data.setMethod(method);
        data.setBody(body);
        String date = ZonedDateTime.now().withZoneSameInstant(ZoneOffset.UTC).format(DATE_FORMATTER);
        data.setDate(date);
        String path = uri.getPath();
        String query = uri.getQuery();
        if (!StringUtils.isEmpty(query)) {
            path = String.format("%s?%s", path, query);
        }
        data.setPath(path);
        data.setContentType(headers.get("Content-Type"));
        try {
            signature = HmacEncoder.encodeRequest(data);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        headers.put("Date", date);
        headers.put("Authorization", String.format("%s %s:%s", SCHEME, this.apiKey, signature));
    }
}

