/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay;

import me.cryptopay.CryptopayBuilder;
import me.cryptopay.JSON;
import me.cryptopay.api.Accounts;
import me.cryptopay.api.Channels;
import me.cryptopay.api.CoinWithdrawals;
import me.cryptopay.api.Coins;
import me.cryptopay.api.Customers;
import me.cryptopay.api.ExchangeTransfers;
import me.cryptopay.api.Invoices;
import me.cryptopay.api.Rates;
import me.cryptopay.api.Risks;
import me.cryptopay.api.Subscriptions;
import me.cryptopay.api.Transactions;
import me.cryptopay.callback.CallbackParser;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.Authentication;
import me.cryptopay.security.HmacValidator;

public final class Cryptopay {
    public static final String CALLBACK_SIGNATURE_HEADER = "X-Cryptopay-Signature";
    public static final String API_URL_PRODUCTION = "https://business.cryptopay.me";
    public static final String API_URL_SANDBOX = "https://business-sandbox.cryptopay.me";
    private static final String USER_AGENT = "Cryptopay Java %s";
    private static final String VERSION = "3.0.0";
    private final ApiClient apiClient;
    private final JSON json;
    private final Accounts accounts;
    private final Channels channels;
    private final CoinWithdrawals coinWithdrawals;
    private final Customers customers;
    private final ExchangeTransfers exchangeTransfers;
    private final Invoices invoices;
    private final Rates rates;
    private final Risks risks;
    private final Transactions transactions;
    private final Coins coins;
    private final Subscriptions subscriptions;
    private final CallbackParser callbacks;

    public Cryptopay(CryptopayBuilder builder) {
        Authentication auth = new Authentication(builder.getApiKey(), builder.getApiSecret());
        this.json = new JSON();
        this.apiClient = new ApiClient(builder.getApiUrl(), auth, this.json, builder.isDebug(), String.format(USER_AGENT, VERSION));
        this.accounts = new Accounts(this.apiClient);
        this.channels = new Channels(this.apiClient);
        this.coinWithdrawals = new CoinWithdrawals(this.apiClient);
        this.customers = new Customers(this.apiClient);
        this.exchangeTransfers = new ExchangeTransfers(this.apiClient);
        this.invoices = new Invoices(this.apiClient);
        this.rates = new Rates(this.apiClient);
        this.risks = new Risks(this.apiClient);
        this.transactions = new Transactions(this.apiClient);
        this.coins = new Coins(this.apiClient);
        this.subscriptions = new Subscriptions(this.apiClient);
        this.callbacks = new CallbackParser(new HmacValidator(builder.getCallbackSecret()), this.json);
    }

    public static CryptopayBuilder builder() {
        return new CryptopayBuilder();
    }

    public Accounts accounts() {
        return this.accounts;
    }

    public Channels channels() {
        return this.channels;
    }

    public CoinWithdrawals coinWithdrawals() {
        return this.coinWithdrawals;
    }

    public Customers customers() {
        return this.customers;
    }

    public ExchangeTransfers exchangeTransfers() {
        return this.exchangeTransfers;
    }

    public Invoices invoices() {
        return this.invoices;
    }

    public Rates rates() {
        return this.rates;
    }

    public Risks risks() {
        return this.risks;
    }

    public Transactions transactions() {
        return this.transactions;
    }

    public Coins coins() {
        return this.coins;
    }

    public Subscriptions subscriptions() {
        return this.subscriptions;
    }

    public CallbackParser callbacks() {
        return this.callbacks;
    }
}

