/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.util.UUID;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.ChannelListResult;
import me.cryptopay.model.ChannelParams;
import me.cryptopay.model.ChannelPaymentListResult;
import me.cryptopay.model.ChannelPaymentResult;
import me.cryptopay.model.ChannelResult;
import me.cryptopay.model.ChannelUpdateParams;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Channels {
    private final ApiClient apiClient;

    public Channels(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateCall create(ChannelParams channelParams) {
        return new CreateCall(channelParams);
    }

    public ListCall list() {
        return new ListCall();
    }

    public ListPaymentsCall listPayments(UUID channelId) {
        return new ListPaymentsCall(channelId);
    }

    public RetrieveCall retrieve(UUID channelId) {
        return new RetrieveCall(channelId);
    }

    public RetrieveByCustomIdCall retrieveByCustomId(String customId) {
        return new RetrieveByCustomIdCall(customId);
    }

    public RetrievePaymentCall retrievePayment(UUID channelId, UUID channelPaymentId) {
        return new RetrievePaymentCall(channelId, channelPaymentId);
    }

    public UpdateCall update(UUID channelId, ChannelUpdateParams channelUpdateParams) {
        return new UpdateCall(channelId, channelUpdateParams);
    }

    public final class CreateCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/channels");

        private CreateCall(ChannelParams channelParams) {
            this.request.setBody(channelParams);
        }

        public ChannelResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelResult.class);
        }
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/channels");

        private ListCall() {
        }

        public ListCall customerId(String customerId) {
            this.request.addQueryParam("customer_id", customerId.toString());
            return this;
        }

        public ListCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public ChannelListResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelListResult.class);
        }
    }

    public final class ListPaymentsCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/channels/{channel_id}/payments");

        private ListPaymentsCall(UUID channelId) {
            this.request.addPathParam("channel_id", channelId.toString());
        }

        public ListPaymentsCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public ChannelPaymentListResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelPaymentListResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/channels/{channel_id}");

        private RetrieveCall(UUID channelId) {
            this.request.addPathParam("channel_id", channelId.toString());
        }

        public ChannelResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelResult.class);
        }
    }

    public final class RetrieveByCustomIdCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/channels/custom_id/{custom_id}");

        private RetrieveByCustomIdCall(String customId) {
            this.request.addPathParam("custom_id", customId.toString());
        }

        public ChannelResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelResult.class);
        }
    }

    public final class RetrievePaymentCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/channels/{channel_id}/payments/{channel_payment_id}");

        private RetrievePaymentCall(UUID channelId, UUID channelPaymentId) {
            this.request.addPathParam("channel_id", channelId.toString());
            this.request.addPathParam("channel_payment_id", channelPaymentId.toString());
        }

        public ChannelPaymentResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelPaymentResult.class);
        }
    }

    public final class UpdateCall {
        private final ApiRequest request = new ApiRequest("PATCH", "/api/channels/{channel_id}");

        private UpdateCall(UUID channelId, ChannelUpdateParams channelUpdateParams) {
            this.request.addPathParam("channel_id", channelId.toString());
            this.request.setBody(channelUpdateParams);
        }

        public ChannelResult execute() throws ApiException {
            return Channels.this.apiClient.execute(this.request, ChannelResult.class);
        }
    }
}

