/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import me.cryptopay.exception.ApiException;
import me.cryptopay.model.CustomerListResult;
import me.cryptopay.model.CustomerParams;
import me.cryptopay.model.CustomerResult;
import me.cryptopay.model.CustomerUpdateParams;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Customers {
    private final ApiClient apiClient;

    public Customers(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateCall create(CustomerParams customerParams) {
        return new CreateCall(customerParams);
    }

    public ListCall list() {
        return new ListCall();
    }

    public RetrieveCall retrieve(String customerId) {
        return new RetrieveCall(customerId);
    }

    public UpdateCall update(String customerId, CustomerUpdateParams customerUpdateParams) {
        return new UpdateCall(customerId, customerUpdateParams);
    }

    public final class CreateCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/customers");

        private CreateCall(CustomerParams customerParams) {
            this.request.setBody(customerParams);
        }

        public CustomerResult execute() throws ApiException {
            return Customers.this.apiClient.execute(this.request, CustomerResult.class);
        }
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/customers");

        private ListCall() {
        }

        public ListCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public CustomerListResult execute() throws ApiException {
            return Customers.this.apiClient.execute(this.request, CustomerListResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/customers/{customer_id}");

        private RetrieveCall(String customerId) {
            this.request.addPathParam("customer_id", customerId.toString());
        }

        public CustomerResult execute() throws ApiException {
            return Customers.this.apiClient.execute(this.request, CustomerResult.class);
        }
    }

    public final class UpdateCall {
        private final ApiRequest request = new ApiRequest("PATCH", "/api/customers/{customer_id}");

        private UpdateCall(String customerId, CustomerUpdateParams customerUpdateParams) {
            this.request.addPathParam("customer_id", customerId.toString());
            this.request.setBody(customerUpdateParams);
        }

        public CustomerResult execute() throws ApiException {
            return Customers.this.apiClient.execute(this.request, CustomerResult.class);
        }
    }
}

