/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.util.UUID;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.ExchangeTransferParams;
import me.cryptopay.model.ExchangeTransferResult;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class ExchangeTransfers {
    private final ApiClient apiClient;

    public ExchangeTransfers(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CommitCall commit(UUID exchangeTransferId) {
        return new CommitCall(exchangeTransferId);
    }

    public CreateCall create(ExchangeTransferParams exchangeTransferParams) {
        return new CreateCall(exchangeTransferParams);
    }

    public RetrieveCall retrieve(UUID exchangeTransferId) {
        return new RetrieveCall(exchangeTransferId);
    }

    public final class CommitCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/exchange_transfers/{exchange_transfer_id}/commit");

        private CommitCall(UUID exchangeTransferId) {
            this.request.addPathParam("exchange_transfer_id", exchangeTransferId.toString());
        }

        public ExchangeTransferResult execute() throws ApiException {
            return ExchangeTransfers.this.apiClient.execute(this.request, ExchangeTransferResult.class);
        }
    }

    public final class CreateCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/exchange_transfers");

        private CreateCall(ExchangeTransferParams exchangeTransferParams) {
            this.request.setBody(exchangeTransferParams);
        }

        public ExchangeTransferResult execute() throws ApiException {
            return ExchangeTransfers.this.apiClient.execute(this.request, ExchangeTransferResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/exchange_transfers/{exchange_transfer_id}");

        private RetrieveCall(UUID exchangeTransferId) {
            this.request.addPathParam("exchange_transfer_id", exchangeTransferId.toString());
        }

        public ExchangeTransferResult execute() throws ApiException {
            return ExchangeTransfers.this.apiClient.execute(this.request, ExchangeTransferResult.class);
        }
    }
}

