/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import me.cryptopay.exception.ApiException;
import me.cryptopay.model.RateResult;
import me.cryptopay.model.RatesResult;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Rates {
    private final ApiClient apiClient;

    public Rates(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AllCall all() {
        return new AllCall();
    }

    public RetrieveCall retrieve(String baseCurrency, String quoteCurrency) {
        return new RetrieveCall(baseCurrency, quoteCurrency);
    }

    public final class AllCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/rates");

        private AllCall() {
        }

        public RatesResult execute() throws ApiException {
            return Rates.this.apiClient.execute(this.request, RatesResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/rates/{base_currency}/{quote_currency}");

        private RetrieveCall(String baseCurrency, String quoteCurrency) {
            this.request.addPathParam("base_currency", baseCurrency.toString());
            this.request.addPathParam("quote_currency", quoteCurrency.toString());
        }

        public RateResult execute() throws ApiException {
            return Rates.this.apiClient.execute(this.request, RateResult.class);
        }
    }
}

