/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.util.UUID;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.SubscriptionListResult;
import me.cryptopay.model.SubscriptionParams;
import me.cryptopay.model.SubscriptionResult;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Subscriptions {
    private final ApiClient apiClient;

    public Subscriptions(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CancelCall cancel(UUID subscriptionId) {
        return new CancelCall(subscriptionId);
    }

    public CreateCall create(SubscriptionParams subscriptionParams) {
        return new CreateCall(subscriptionParams);
    }

    public ListCall list() {
        return new ListCall();
    }

    public RetrieveCall retrieve(UUID subscriptionId) {
        return new RetrieveCall(subscriptionId);
    }

    public RetrieveByCustomIdCall retrieveByCustomId(String customId) {
        return new RetrieveByCustomIdCall(customId);
    }

    public final class CancelCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/subscriptions/{subscription_id}/cancel");

        private CancelCall(UUID subscriptionId) {
            this.request.addPathParam("subscription_id", subscriptionId.toString());
        }

        public SubscriptionResult execute() throws ApiException {
            return Subscriptions.this.apiClient.execute(this.request, SubscriptionResult.class);
        }
    }

    public final class CreateCall {
        private final ApiRequest request = new ApiRequest("POST", "/api/subscriptions");

        private CreateCall(SubscriptionParams subscriptionParams) {
            this.request.setBody(subscriptionParams);
        }

        public SubscriptionResult execute() throws ApiException {
            return Subscriptions.this.apiClient.execute(this.request, SubscriptionResult.class);
        }
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/subscriptions");

        private ListCall() {
        }

        public ListCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public SubscriptionListResult execute() throws ApiException {
            return Subscriptions.this.apiClient.execute(this.request, SubscriptionListResult.class);
        }
    }

    public final class RetrieveCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/subscriptions/{subscription_id}");

        private RetrieveCall(UUID subscriptionId) {
            this.request.addPathParam("subscription_id", subscriptionId.toString());
        }

        public SubscriptionResult execute() throws ApiException {
            return Subscriptions.this.apiClient.execute(this.request, SubscriptionResult.class);
        }
    }

    public final class RetrieveByCustomIdCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/subscriptions/custom_id/{custom_id}");

        private RetrieveByCustomIdCall(String customId) {
            this.request.addPathParam("custom_id", customId.toString());
        }

        public SubscriptionResult execute() throws ApiException {
            return Subscriptions.this.apiClient.execute(this.request, SubscriptionResult.class);
        }
    }
}

