/*
 * Decompiled with CFR 0.152.
 */
package me.cryptopay.api;

import java.time.OffsetDateTime;
import me.cryptopay.exception.ApiException;
import me.cryptopay.model.RiskLevel;
import me.cryptopay.model.TransactionListResult;
import me.cryptopay.model.TransactionReferenceType;
import me.cryptopay.net.ApiClient;
import me.cryptopay.net.ApiRequest;

public class Transactions {
    private final ApiClient apiClient;

    public Transactions(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ListCall list() {
        return new ListCall();
    }

    public final class ListCall {
        private final ApiRequest request = new ApiRequest("GET", "/api/transactions");

        private ListCall() {
        }

        public ListCall createdAtFrom(OffsetDateTime createdAtFrom) {
            this.request.addQueryParam("created_at_from", createdAtFrom.toString());
            return this;
        }

        public ListCall createdAtTo(OffsetDateTime createdAtTo) {
            this.request.addQueryParam("created_at_to", createdAtTo.toString());
            return this;
        }

        public ListCall referenceType(TransactionReferenceType referenceType) {
            this.request.addQueryParam("reference_type", referenceType.toString());
            return this;
        }

        public ListCall currency(String currency) {
            this.request.addQueryParam("currency", currency.toString());
            return this;
        }

        public ListCall status(String status) {
            this.request.addQueryParam("status", status.toString());
            return this;
        }

        public ListCall riskLevel(RiskLevel riskLevel) {
            this.request.addQueryParam("risk_level", riskLevel.toString());
            return this;
        }

        public ListCall startingAfter(String startingAfter) {
            this.request.addQueryParam("starting_after", startingAfter.toString());
            return this;
        }

        public TransactionListResult execute() throws ApiException {
            return Transactions.this.apiClient.execute(this.request, TransactionListResult.class);
        }
    }
}

