/*
 * Decompiled with CFR 0.152.
 */
package mp.code;

import java.util.Optional;
import java.util.function.Consumer;
import mp.code.NativeUtils;
import mp.code.data.TextChange;
import mp.code.exceptions.ControllerException;

public final class BufferController {
    private final long ptr;

    BufferController(long ptr) {
        this.ptr = ptr;
    }

    private static native String get_name(long var0);

    public String getName() {
        return BufferController.get_name(this.ptr);
    }

    private static native String get_content(long var0) throws ControllerException;

    public String getContent() throws ControllerException {
        return BufferController.get_content(this.ptr);
    }

    private static native TextChange try_recv(long var0) throws ControllerException;

    public Optional<TextChange> tryRecv() throws ControllerException {
        return Optional.ofNullable(BufferController.try_recv(this.ptr));
    }

    private static native TextChange recv(long var0) throws ControllerException;

    public TextChange recv() throws ControllerException {
        return BufferController.recv(this.ptr);
    }

    private static native void send(long var0, TextChange var2) throws ControllerException;

    public void send(TextChange change) throws ControllerException {
        BufferController.send(this.ptr, change);
    }

    private static native void callback(long var0, Consumer<BufferController> var2);

    public void callback(Consumer<BufferController> cb) {
        BufferController.callback(this.ptr, cb);
    }

    private static native void clear_callback(long var0);

    public void clearCallback() {
        BufferController.clear_callback(this.ptr);
    }

    private static native void poll(long var0) throws ControllerException;

    public void poll() throws ControllerException {
        BufferController.poll(this.ptr);
    }

    private static native boolean stop(long var0);

    public boolean stop() {
        return BufferController.stop(this.ptr);
    }

    private static native void free(long var0);

    protected void finalize() {
        BufferController.free(this.ptr);
    }

    static {
        NativeUtils.loadLibraryIfNeeded();
    }
}

