/*
 * Decompiled with CFR 0.152.
 */
package mp.code;

import java.util.Optional;
import java.util.UUID;
import mp.code.BufferController;
import mp.code.CursorController;
import mp.code.NativeUtils;
import mp.code.data.DetachResult;
import mp.code.exceptions.ConnectionException;
import mp.code.exceptions.ConnectionRemoteException;
import mp.code.exceptions.ControllerException;

public final class Workspace {
    private final long ptr;

    Workspace(long ptr) {
        this.ptr = ptr;
    }

    private static native String get_workspace_id(long var0);

    public String getWorkspaceId() {
        return Workspace.get_workspace_id(this.ptr);
    }

    private static native CursorController get_cursor(long var0);

    public CursorController getCursor() {
        return Workspace.get_cursor(this.ptr);
    }

    private static native BufferController get_buffer(long var0, String var2);

    public Optional<BufferController> getBuffer(String path) {
        return Optional.ofNullable(Workspace.get_buffer(this.ptr, path));
    }

    private static native String[] get_file_tree(long var0, String var2, boolean var3);

    public String[] getFileTree(Optional<String> filter, boolean strict) {
        return Workspace.get_file_tree(this.ptr, filter.orElse(null), strict);
    }

    private static native String[] active_buffers(long var0);

    public String[] activeBuffers() {
        return Workspace.active_buffers(this.ptr);
    }

    private static native void create_buffer(long var0, String var2) throws ConnectionRemoteException;

    public void createBuffer(String path) throws ConnectionRemoteException {
        Workspace.create_buffer(this.ptr, path);
    }

    private static native BufferController attach_to_buffer(long var0, String var2) throws ConnectionException;

    public BufferController attachToBuffer(String path) throws ConnectionException {
        return Workspace.attach_to_buffer(this.ptr, path);
    }

    private static native DetachResult detach_from_buffer(long var0, String var2);

    public DetachResult detachFromBuffer(String path) {
        return Workspace.detach_from_buffer(this.ptr, path);
    }

    private static native void fetch_buffers(long var0) throws ConnectionRemoteException;

    public void fetchBuffers() throws ConnectionRemoteException {
        Workspace.fetch_buffers(this.ptr);
    }

    private static native void fetch_users(long var0) throws ConnectionRemoteException;

    public void fetchUsers() throws ConnectionRemoteException {
        Workspace.fetch_buffers(this.ptr);
    }

    private static native UUID[] list_buffer_users(long var0, String var2) throws ConnectionRemoteException;

    public UUID[] listBufferUsers(String path) throws ConnectionRemoteException {
        return Workspace.list_buffer_users(this.ptr, path);
    }

    private static native void delete_buffer(long var0, String var2) throws ConnectionRemoteException;

    public void deleteBuffer(String path) throws ConnectionRemoteException {
        Workspace.delete_buffer(this.ptr, path);
    }

    private static native Event event(long var0) throws ControllerException;

    public Event event() throws ControllerException {
        return Workspace.event(this.ptr);
    }

    private static native void free(long var0);

    protected void finalize() {
        Workspace.free(this.ptr);
    }

    static {
        NativeUtils.loadLibraryIfNeeded();
    }

    public static final class Event {
        private final Type type;
        private final String argument;

        Event(Type type, String argument) {
            this.type = type;
            this.argument = argument;
        }

        public Optional<String> getUserJoined() {
            if (this.type == Type.USER_JOIN) {
                return Optional.of(this.argument);
            }
            return Optional.empty();
        }

        public Optional<String> getUserLeft() {
            if (this.type == Type.USER_LEAVE) {
                return Optional.of(this.argument);
            }
            return Optional.empty();
        }

        public Optional<String> getChangedBuffer() {
            if (this.type == Type.FILE_TREE_UPDATED) {
                return Optional.of(this.argument);
            }
            return Optional.empty();
        }

        static enum Type {
            USER_JOIN,
            USER_LEAVE,
            FILE_TREE_UPDATED;

        }
    }
}

