/*
 * Decompiled with CFR 0.152.
 */
package mp.code;

import java.util.Optional;
import lombok.Generated;
import mp.code.Extensions;
import mp.code.NativeUtils;
import mp.code.Workspace;
import mp.code.data.Config;
import mp.code.data.User;
import mp.code.exceptions.ConnectionException;
import mp.code.exceptions.ConnectionRemoteException;

public final class Client {
    private final long ptr;

    Client(long ptr) {
        this.ptr = ptr;
        Extensions.CLEANER.register(this, () -> Client.free(ptr));
    }

    public static native Client connect(Config var0) throws ConnectionException;

    private static native User get_user(long var0);

    public User getUser() {
        return Client.get_user(this.ptr);
    }

    private static native Workspace join_workspace(long var0, String var2) throws ConnectionException;

    public Workspace joinWorkspace(String workspaceId) throws ConnectionException {
        return Client.join_workspace(this.ptr, workspaceId);
    }

    private static native void create_workspace(long var0, String var2) throws ConnectionRemoteException;

    public void createWorkspace(String workspaceId) throws ConnectionRemoteException {
        Client.create_workspace(this.ptr, workspaceId);
    }

    private static native void delete_workspace(long var0, String var2) throws ConnectionRemoteException;

    public void deleteWorkspace(String workspaceId) throws ConnectionRemoteException {
        Client.delete_workspace(this.ptr, workspaceId);
    }

    private static native void invite_to_workspace(long var0, String var2, String var3) throws ConnectionRemoteException;

    public void inviteToWorkspace(String workspaceId, String user) throws ConnectionRemoteException {
        Client.invite_to_workspace(this.ptr, workspaceId, user);
    }

    private static native String[] list_workspaces(long var0, boolean var2, boolean var3) throws ConnectionRemoteException;

    public String[] listWorkspaces(boolean owned, boolean invited) throws ConnectionRemoteException {
        return Client.list_workspaces(this.ptr, owned, invited);
    }

    private static native String[] active_workspaces(long var0);

    public String[] activeWorkspaces() {
        return Client.active_workspaces(this.ptr);
    }

    private static native boolean leave_workspace(long var0, String var2);

    public boolean leaveWorkspace(String workspaceId) {
        return Client.leave_workspace(this.ptr, workspaceId);
    }

    private static native Workspace get_workspace(long var0, String var2);

    public Optional<Workspace> getWorkspace(String workspaceId) {
        return Optional.ofNullable(Client.get_workspace(this.ptr, workspaceId));
    }

    private static native void refresh(long var0) throws ConnectionRemoteException;

    public void refresh() throws ConnectionRemoteException {
        Client.refresh(this.ptr);
    }

    private static native void free(long var0);

    @Generated
    public long getPtr() {
        return this.ptr;
    }

    static {
        NativeUtils.loadLibraryIfNeeded();
    }
}

