/*
 * Decompiled with CFR 0.152.
 */
package mp.code;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.util.Objects;

class NativeUtils {
    private static final int MIN_PREFIX_LENGTH = 3;
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static File temporaryDir;
    private static boolean loaded;

    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryFromJar(String path) throws IOException {
        String filename;
        if (null == path || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtils.createTempDirectory();
            temporaryDir.deleteOnExit();
        }
        File temp = new File(temporaryDir, filename);
        try (InputStream is = NativeUtils.class.getResourceAsStream(path);){
            Files.copy(Objects.requireNonNull(is), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            temp.delete();
            throw e;
        }
        catch (NullPointerException e) {
            temp.delete();
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        try {
            System.load(temp.getAbsolutePath());
        }
        finally {
            if (NativeUtils.isPosixCompliant()) {
                temp.delete();
            } else {
                temp.deleteOnExit();
            }
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private static File createTempDirectory() throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, NATIVE_FOLDER_PATH_PREFIX + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }

    static synchronized void loadLibraryIfNeeded() {
        if (loaded) {
            return;
        }
        try {
            String os = System.getProperty("os.name").toLowerCase();
            String filename = os.startsWith("windows") ? "/natives/codemp.dll" : (os.startsWith("mac") ? "/natives/libcodemp.dylib" : "/natives/libcodemp.so");
            NativeUtils.loadLibraryFromJar(filename);
            loaded = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        loaded = false;
    }
}

