/*
 * Decompiled with CFR 0.152.
 */
package mp.code;

import java.util.Optional;
import java.util.function.Consumer;
import mp.code.Extensions;
import mp.code.NativeUtils;
import mp.code.data.Cursor;
import mp.code.data.Selection;
import mp.code.exceptions.ControllerException;

public final class CursorController {
    private final long ptr;

    CursorController(long ptr) {
        this.ptr = ptr;
        Extensions.CLEANER.register(this, () -> CursorController.free(ptr));
    }

    private static native Cursor try_recv(long var0) throws ControllerException;

    public Optional<Cursor> tryRecv() throws ControllerException {
        return Optional.ofNullable(CursorController.try_recv(this.ptr));
    }

    private static native Cursor recv(long var0) throws ControllerException;

    public Cursor recv() throws ControllerException {
        return CursorController.recv(this.ptr);
    }

    private static native void send(long var0, Selection var2) throws ControllerException;

    public void send(Selection selection) throws ControllerException {
        CursorController.send(this.ptr, selection);
    }

    private static native void callback(long var0, Consumer<CursorController> var2);

    public void callback(Consumer<CursorController> cb) {
        CursorController.callback(this.ptr, cb);
    }

    private static native void clear_callback(long var0);

    public void clearCallback() {
        CursorController.clear_callback(this.ptr);
    }

    private static native void poll(long var0) throws ControllerException;

    public void poll() throws ControllerException {
        CursorController.poll(this.ptr);
    }

    private static native void free(long var0);

    static {
        NativeUtils.loadLibraryIfNeeded();
    }
}

