/*
 * Decompiled with CFR 0.152.
 */
package mp.code;

import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import mp.code.BufferController;
import mp.code.CursorController;
import mp.code.Extensions;
import mp.code.NativeUtils;
import mp.code.data.User;
import mp.code.exceptions.ConnectionException;
import mp.code.exceptions.ConnectionRemoteException;
import mp.code.exceptions.ControllerException;

public final class Workspace {
    private final long ptr;

    Workspace(long ptr) {
        this.ptr = ptr;
        Extensions.CLEANER.register(this, () -> Workspace.free(ptr));
    }

    private static native String id(long var0);

    public String id() {
        return Workspace.id(this.ptr);
    }

    private static native CursorController cursor(long var0);

    public CursorController cursor() {
        return Workspace.cursor(this.ptr);
    }

    private static native BufferController get_buffer(long var0, String var2);

    public Optional<BufferController> getBuffer(String path) {
        return Optional.ofNullable(Workspace.get_buffer(this.ptr, path));
    }

    private static native String[] search_buffers(long var0, String var2);

    public String[] searchBuffers(Optional<String> filter) {
        return Workspace.search_buffers(this.ptr, filter.orElse(null));
    }

    private static native String[] active_buffers(long var0);

    public String[] activeBuffers() {
        return Workspace.active_buffers(this.ptr);
    }

    private static native User[] user_list(long var0);

    public User[] userList() {
        return Workspace.user_list(this.ptr);
    }

    private static native void create_buffer(long var0, String var2) throws ConnectionRemoteException;

    public void createBuffer(String path) throws ConnectionRemoteException {
        Workspace.create_buffer(this.ptr, path);
    }

    private static native BufferController attach_buffer(long var0, String var2) throws ConnectionException;

    public BufferController attachBuffer(String path) throws ConnectionException {
        return Workspace.attach_buffer(this.ptr, path);
    }

    private static native boolean detach_buffer(long var0, String var2);

    public boolean detachBuffer(String path) {
        return Workspace.detach_buffer(this.ptr, path);
    }

    private static native String[] fetch_buffers(long var0) throws ConnectionRemoteException;

    public String[] fetchBuffers() throws ConnectionRemoteException {
        return Workspace.fetch_buffers(this.ptr);
    }

    private static native User[] fetch_users(long var0) throws ConnectionRemoteException;

    public User[] fetchUsers() throws ConnectionRemoteException {
        return Workspace.fetch_users(this.ptr);
    }

    private static native User[] fetch_buffer_users(long var0, String var2) throws ConnectionRemoteException;

    public User[] fetchBufferUsers(String path) throws ConnectionRemoteException {
        return Workspace.fetch_buffer_users(this.ptr, path);
    }

    private static native void delete_buffer(long var0, String var2) throws ConnectionRemoteException;

    public void deleteBuffer(String path) throws ConnectionRemoteException {
        Workspace.delete_buffer(this.ptr, path);
    }

    private static native Event try_recv(long var0) throws ControllerException;

    public Optional<Event> tryRecv() throws ControllerException {
        return Optional.ofNullable(Workspace.try_recv(this.ptr));
    }

    private static native Event recv(long var0) throws ControllerException;

    public Event recv() throws ControllerException {
        return Workspace.recv(this.ptr);
    }

    private static native void callback(long var0, Consumer<Workspace> var2);

    public void callback(Consumer<Workspace> cb) {
        Workspace.callback(this.ptr, cb);
    }

    private static native void clear_callback(long var0);

    public void clearCallback() {
        Workspace.clear_callback(this.ptr);
    }

    private static native void poll(long var0) throws ControllerException;

    public void poll() throws ControllerException {
        Workspace.poll(this.ptr);
    }

    private static native void free(long var0);

    static {
        NativeUtils.loadLibraryIfNeeded();
    }

    public static final class Event {
        public final Type type;
        private final String argument;

        Event(Type type, String argument) {
            this.type = type;
            this.argument = argument;
        }

        public Optional<String> getUserJoined() {
            if (this.type == Type.USER_JOIN) {
                return Optional.of(this.argument);
            }
            return Optional.empty();
        }

        public Optional<String> getUserLeft() {
            if (this.type == Type.USER_LEAVE) {
                return Optional.of(this.argument);
            }
            return Optional.empty();
        }

        public Optional<String> getChangedBuffer() {
            if (this.type == Type.FILE_TREE_UPDATED) {
                return Optional.of(this.argument);
            }
            return Optional.empty();
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        public static enum Type {
            USER_JOIN,
            USER_LEAVE,
            FILE_TREE_UPDATED;

        }
    }
}

