/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Constants;
import net.adamcin.httpsig.api.DefaultKeychain;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.KeyIdentifier;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.api.SignatureBuilder;
import net.adamcin.httpsig.api.VerifyResult;

public final class Verifier {
    public static final long DEFAULT_SKEW = 300000L;
    private final Keychain keychain;
    private KeyIdentifier keyIdentifier;
    private long skew = 300000L;

    public Verifier(Keychain keychain) {
        this(keychain, null);
    }

    public Verifier(Keychain keychain, KeyIdentifier keyIdentifier) {
        this.keychain = keychain != null ? keychain : new DefaultKeychain();
        this.keyIdentifier = new CanVerifyIdentifier(keyIdentifier != null ? keyIdentifier : Constants.DEFAULT_KEY_IDENTIFIER);
    }

    public Keychain getKeychain() {
        return this.keychain;
    }

    public long getSkew() {
        return this.skew;
    }

    public void setSkew(long skew) {
        this.skew = skew;
    }

    public boolean verify(Challenge challenge, SignatureBuilder signatureBuilder, Authorization authorization) {
        return this.verifyWithResult(challenge, signatureBuilder, authorization) == VerifyResult.SUCCESS;
    }

    public VerifyResult verifyWithResult(Challenge challenge, SignatureBuilder signatureBuilder, Authorization authorization) {
        Key key;
        if (challenge == null) {
            throw new IllegalArgumentException("challenge cannot be null");
        }
        if (signatureBuilder == null) {
            throw new IllegalArgumentException("signatureBuilder cannot be null");
        }
        if (authorization == null) {
            throw new IllegalArgumentException("authorization cannot be null");
        }
        for (String header : challenge.getHeaders()) {
            if (header.startsWith(":") || authorization.getHeaders().contains(header)) continue;
            return VerifyResult.CHALLENGE_NOT_SATISFIED;
        }
        for (String header : authorization.getHeaders()) {
            if (!signatureBuilder.getHeaderValues(header).isEmpty()) continue;
            return VerifyResult.INCOMPLETE_REQUEST;
        }
        if (authorization.getHeaders().contains("date") && this.skew >= 0L) {
            Date requestTime = signatureBuilder.getDateGMT();
            Date currentTime = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
            Date past = new Date(currentTime.getTime() - this.skew);
            Date future = new Date(currentTime.getTime() + this.skew);
            if (requestTime.before(past) || requestTime.after(future)) {
                return VerifyResult.EXPIRED_DATE_HEADER;
            }
        }
        if ((key = this.keychain.toMap(this.keyIdentifier).get(authorization.getKeyId())) == null) {
            return VerifyResult.KEY_NOT_FOUND;
        }
        if (key.verify(authorization.getAlgorithm(), signatureBuilder.buildContent(authorization.getHeaders(), Constants.CHARSET), authorization.getSignatureBytes())) {
            return VerifyResult.SUCCESS;
        }
        return VerifyResult.FAILED_KEY_VERIFY;
    }

    private static class CanVerifyIdentifier
    implements KeyIdentifier {
        private KeyIdentifier delegatee;

        private CanVerifyIdentifier(KeyIdentifier delegatee) {
            this.delegatee = delegatee;
        }

        public String getId(Key key) {
            if (key != null && key.canVerify()) {
                return this.delegatee.getId(key);
            }
            return null;
        }
    }
}

