/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.KeyId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constants {
    public static final String SCHEME = "Signature";
    public static final String CHALLENGE = "WWW-Authenticate";
    public static final String REALM = "realm";
    public static final String KEY_ID = "keyId";
    public static final String HEADER_REQUEST_LINE = "request-line";
    public static final String HEADER_DATE = "date";
    public static final List<String> DEFAULT_HEADERS = Arrays.asList("date");
    public static final String AUTHORIZATION = "Authorization";
    public static final String HEADERS = "headers";
    public static final String SIGNATURE = "signature";
    public static final String ALGORITHMS = "algorithms";
    public static final String ALGORITHM = "algorithm";
    public static final Charset CHARSET = Charset.forName("ISO-8859-1");
    public static final Pattern RFC2617_PARAM = Pattern.compile("(^|\\s)(\\w+)=\"([^\"]*)\"");
    public static final KeyId DEFAULT_KEY_IDENTIFIER = new KeyId(){

        public String getId(Key key) {
            return key.getId();
        }
    };
    public static final Collection<Algorithm> ALL_SUPPORTED_ALGORITHMS = Arrays.asList(Algorithm.values());
    public static final Challenge PREEMPTIVE_CHALLENGE = new Challenge("<preemptive>", DEFAULT_HEADERS, ALL_SUPPORTED_ALGORITHMS);

    public static final List<String> parseTokens(String tokens) {
        String[] _tokens;
        if (tokens == null || tokens.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        for (String _token : _tokens = tokens.trim().split("\\s+")) {
            tokenList.add(_token);
        }
        return Collections.unmodifiableList(tokenList);
    }

    public static final String constructTokensString(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        if (tokens != null) {
            for (String token : tokens) {
                sb.append(token).append(" ");
            }
        }
        return sb.toString();
    }

    public static final Map<String, String> parseRFC2617(String header) {
        HashMap<String, String> params = new HashMap<String, String>();
        Matcher matcher = RFC2617_PARAM.matcher(header);
        while (matcher.find()) {
            params.put(matcher.group(2), matcher.group(3));
        }
        return Collections.unmodifiableMap(params);
    }

    public static final String constructRFC2617(Map<String, String> params) {
        StringBuilder sb = new StringBuilder(SCHEME);
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                sb.append(" ").append(param.getKey()).append("=\"").append(param.getValue()).append("\"").append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Constants() {
    }
}

