/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.hmac;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmacKey
implements Key {
    private final String keyId;
    private final String secret;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Logger LOGGER = LoggerFactory.getLogger(HmacKey.class);

    public HmacKey(String keyId, String secret) {
        if (keyId == null) {
            throw new NullPointerException("keyId must not be null");
        }
        if (secret == null) {
            throw new NullPointerException("secret must not be null");
        }
        this.keyId = keyId;
        this.secret = secret;
    }

    public String getId() {
        return this.keyId;
    }

    public Set<Algorithm> getAlgorithms() {
        HashSet<Algorithm> algorithms = new HashSet<Algorithm>();
        algorithms.add(Algorithm.HMAC_SHA512);
        algorithms.add(Algorithm.HMAC_SHA256);
        return algorithms;
    }

    public boolean canVerify() {
        return true;
    }

    public boolean verify(Algorithm algorithm, byte[] contentBytes, byte[] signatureBytes) {
        if (this.getAlgorithms().contains(algorithm)) {
            byte[] generatedSig = this.sign(algorithm, contentBytes);
            return Arrays.equals(generatedSig, signatureBytes);
        }
        return false;
    }

    private String mapAlgorithm(Algorithm algorithm) {
        if ("hmac-sha512".equalsIgnoreCase(algorithm.getName())) {
            return "HmacSHA512";
        }
        if ("hmac-sha256".equalsIgnoreCase(algorithm.getName())) {
            return "HmacSHA256";
        }
        throw new IllegalArgumentException(String.format("Unsupported algorithm: %s", algorithm.getName()));
    }

    public boolean canSign() {
        return true;
    }

    public byte[] sign(Algorithm algorithm, byte[] contentBytes) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secret.getBytes(), this.mapAlgorithm(algorithm));
            Mac mac = Mac.getInstance(this.mapAlgorithm(algorithm));
            mac.init(secretKeySpec);
            return mac.doFinal(contentBytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("[sign] failed to sign content.", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOGGER.error("[sign] failed to sign content.", (Throwable)e);
        }
        return EMPTY_BYTES;
    }
}

