/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.bc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Logger;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.ssh.jce.KeyFormat;
import net.adamcin.httpsig.ssh.jce.SSHKey;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class PEMUtil {
    private static final Logger LOGGER = Logger.getLogger(PEMUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key readKey(InputStream is, char[] passphrase) throws IOException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        PEMParser parser = null;
        KeyPair keyPair = null;
        try {
            SSHKey sSHKey;
            parser = new PEMParser((Reader)new InputStreamReader(is));
            Object o = parser.readObject();
            if (o instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair _encPair = (PEMEncryptedKeyPair)o;
                PEMDecryptorProvider decryptionProv = new JcePEMDecryptorProviderBuilder().build(passphrase);
                keyPair = converter.getKeyPair(_encPair.decryptKeyPair(decryptionProv));
            } else if (o instanceof PEMKeyPair) {
                keyPair = converter.getKeyPair((PEMKeyPair)o);
            }
            if (keyPair != null) {
                if (keyPair.getPrivate() instanceof RSAPrivateKey || keyPair.getPublic() instanceof RSAPublicKey) {
                    sSHKey = new SSHKey(KeyFormat.SSH_RSA, keyPair);
                    return sSHKey;
                }
                if (keyPair.getPrivate() instanceof DSAPrivateKey || keyPair.getPublic() instanceof DSAPublicKey) {
                    sSHKey = new SSHKey(KeyFormat.SSH_DSS, keyPair);
                    return sSHKey;
                }
            }
            sSHKey = null;
            return sSHKey;
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key readKey(File privateKeyFile, char[] passphrase) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(privateKeyFile);
            Key key = PEMUtil.readKey(is, passphrase);
            return key;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key readKey(byte[] keyBytes, char[] passphrase) throws IOException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(keyBytes);
            Key key = PEMUtil.readKey(is, passphrase);
            return key;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

