/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.ssh.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Signature;
import com.jcraft.jsch.jce.SignatureDSA;
import com.jcraft.jsch.jce.SignatureRSA;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.DefaultKeychain;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.ssh.jce.FingerprintableKey;
import net.adamcin.httpsig.ssh.jce.Magic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JschKey
implements FingerprintableKey {
    private static final Logger LOGGER = LoggerFactory.getLogger(JschKey.class);
    private final String fingerprint;
    private final Algorithm algorithm;
    private final Identity identity;

    public JschKey(Identity identity) {
        this.fingerprint = Magic.getFingerprint((byte[])identity.getPublicKeyBlob());
        this.identity = identity;
        this.algorithm = Algorithm.forName((String)identity.getAlgName());
    }

    public String getId() {
        return this.fingerprint;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public Set<Algorithm> getAlgorithms() {
        return Collections.unmodifiableSet(this.algorithm == null ? new HashSet() : new HashSet<Algorithm>(Arrays.asList(this.algorithm)));
    }

    public boolean verify(Algorithm algorithm, byte[] challengeHash, byte[] signatureBytes) {
        if (algorithm == this.algorithm) {
            try {
                Signature signature = this.getSignature(challengeHash);
                return signature.verify(signatureBytes);
            }
            catch (Exception e) {
                LOGGER.error("[verify] signature verification failed.", (Throwable)e);
            }
        }
        return false;
    }

    public boolean canVerify() {
        try {
            return this.getSignature("test".getBytes()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canSign() {
        try {
            return this.identity.getSignature("test".getBytes()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Signature getSignature(byte[] challengeHash) throws Exception {
        if (Algorithm.SSH_RSA == this.algorithm) {
            SignatureRSA signature = new SignatureRSA();
            Buffer buf = new Buffer(this.identity.getPublicKeyBlob());
            signature.init();
            buf.getString();
            byte[] e = buf.getString();
            byte[] n = buf.getString();
            signature.setPubKey(e, n);
            signature.update(challengeHash);
            return signature;
        }
        if (Algorithm.SSH_DSS == this.algorithm) {
            SignatureDSA signature = new SignatureDSA();
            Buffer buf = new Buffer(this.identity.getPublicKeyBlob());
            signature.init();
            buf.getString();
            byte[] p = buf.getString();
            byte[] q = buf.getString();
            byte[] g = buf.getString();
            byte[] pub_array = buf.getString();
            signature.setPubKey(pub_array, p, q, g);
            signature.update(challengeHash);
            return signature;
        }
        throw new Exception("Unsupported public key algorithm: " + this.identity.getAlgName());
    }

    public byte[] sign(Algorithm algorithm, byte[] challengeHash) {
        return this.identity.getSignature(challengeHash);
    }

    public static Keychain getIdentities(JSch jSch) {
        ArrayList<JschKey> identities = new ArrayList<JschKey>();
        Vector _identities = jSch.getIdentityRepository().getIdentities();
        if (_identities != null) {
            for (Object obj : _identities) {
                identities.add(new JschKey((Identity)obj));
            }
        }
        return new DefaultKeychain(Collections.unmodifiableList(identities));
    }
}

