/*
 * Decompiled with CFR 0.152.
 */
package net.east301.keyring.example;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.east301.keyring.BackendNotSupportedException;
import net.east301.keyring.Keyring;
import net.east301.keyring.PasswordRetrievalException;
import net.east301.keyring.PasswordSaveException;
import net.east301.keyring.util.LockException;

public class Program {
    public static void main(String[] args) {
        Keyring keyring;
        try {
            keyring = Keyring.create();
        }
        catch (BackendNotSupportedException ex) {
            Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        if (keyring.isKeyStorePathRequired()) {
            try {
                File keyStoreFile = File.createTempFile("keystore", ".keystore");
                keyring.setKeyStorePath(keyStoreFile.getPath());
            }
            catch (IOException ex) {
                Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            keyring.setPassword("My service name", "My account name", "My password");
        }
        catch (LockException ex) {
            Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (PasswordSaveException ex) {
            Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            String password = keyring.getPassword("My service name", "My account name");
            System.out.println(password);
        }
        catch (LockException ex) {
            Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (PasswordRetrievalException ex) {
            Logger.getLogger(Program.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

