/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.Common;
import net.java.ao.RawEntity;
import net.java.ao.RelatedEntity;
import net.java.ao.SearchableEntityManager;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similar.MoreLikeThis;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelatedEntityImpl {
    private RawEntity<Object> entity;

    public RelatedEntityImpl(RelatedEntity<?> entity) {
        this.entity = (RawEntity)((Object)entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedEntity<?>[] getRelated() throws IOException {
        Class type = this.entity.getEntityType();
        String table = this.entity.getEntityManager().getTableNameConverter().getName(type);
        List<String> indexFields = Common.getSearchableFields(this.entity.getEntityManager(), type);
        String[] searchFields = new String[indexFields.size()];
        for (int i = 0; i < searchFields.length; ++i) {
            searchFields[i] = table + '.' + indexFields.get(i);
        }
        Directory indexDir = ((SearchableEntityManager)this.entity.getEntityManager()).getIndexDir();
        IndexReader reader = null;
        reader = IndexReader.open((Directory)indexDir);
        IndexSearcher searcher = new IndexSearcher(indexDir);
        MoreLikeThis more = new MoreLikeThis(reader);
        more.setFieldNames(searchFields);
        more.setAnalyzer(((SearchableEntityManager)this.entity.getEntityManager()).getAnalyzer());
        int docID = -1;
        String primaryKeyField = Common.getPrimaryKeyField(this.entity.getEntityType(), this.entity.getEntityManager().getFieldNameConverter());
        Object primaryKeyValue = Common.getPrimaryKeyValue(this.entity);
        TermDocs docs = reader.termDocs(new Term(table + "." + primaryKeyField, Common.getPrimaryKeyType(type).valueToString(primaryKeyValue)));
        if (docs.next()) {
            docID = docs.doc();
        }
        if (docID < 0) {
            RelatedEntity[] relatedEntityArray = (RelatedEntity[])Array.newInstance(type, 0);
            return relatedEntityArray;
        }
        Query query = more.like(docID);
        Hits hits = searcher.search(query);
        ArrayList<RelatedEntity> back = new ArrayList<RelatedEntity>();
        for (int i = 0; i < hits.length(); ++i) {
            String entityKey = hits.doc(i).get(table + "." + primaryKeyField);
            if (entityKey.equals(primaryKeyValue.toString())) continue;
            back.add((RelatedEntity)this.entity.getEntityManager().peer(type, Common.getPrimaryKeyType(type).defaultParseValue(entityKey)));
        }
        RelatedEntity[] relatedEntityArray = back.toArray((RelatedEntity[])Array.newInstance(type, back.size()));
        return relatedEntityArray;
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

