/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder;

import com.google.common.base.Preconditions;
import net.java.ao.DefaultSchemaConfiguration;
import net.java.ao.EntityManager;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.SchemaConfiguration;
import net.java.ao.builder.DatabaseProperties;
import net.java.ao.event.EventManager;
import net.java.ao.event.EventManagerImpl;
import net.java.ao.schema.CamelCaseFieldNameConverter;
import net.java.ao.schema.CamelCaseTableNameConverter;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.TableNameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerBuilderWithDatabaseProperties<B extends AbstractEntityManagerBuilderWithDatabaseProperties> {
    private final DatabaseProperties databaseProperties;
    private final BuilderEntityManagerConfiguration configuration;
    private EventManager eventManager;

    AbstractEntityManagerBuilderWithDatabaseProperties(DatabaseProperties databaseProperties) {
        this(databaseProperties, new BuilderEntityManagerConfiguration(), null);
    }

    AbstractEntityManagerBuilderWithDatabaseProperties(DatabaseProperties databaseProperties, BuilderEntityManagerConfiguration configuration, EventManager eventManager) {
        this.databaseProperties = (DatabaseProperties)Preconditions.checkNotNull((Object)databaseProperties);
        this.configuration = (BuilderEntityManagerConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.eventManager = eventManager;
    }

    public B tableNameConverter(TableNameConverter tableNameConverter) {
        this.configuration.setTableNameConverter((TableNameConverter)Preconditions.checkNotNull((Object)tableNameConverter));
        return this.cast();
    }

    public B fieldNameConverter(FieldNameConverter fieldNameConverter) {
        this.configuration.setFieldNameConverter((FieldNameConverter)Preconditions.checkNotNull((Object)fieldNameConverter));
        return this.cast();
    }

    public B schemaConfiguration(SchemaConfiguration schemaConfiguration) {
        this.configuration.setSchemaConfiguration(schemaConfiguration);
        return this.cast();
    }

    public B useWeakCache() {
        this.configuration.setUseWeakCache(true);
        return this.cast();
    }

    public B eventManager(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        return this.cast();
    }

    final EventManager getEventManager() {
        return this.eventManager != null ? this.eventManager : new EventManagerImpl();
    }

    final DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    final BuilderEntityManagerConfiguration getEntityManagerConfiguration() {
        return this.configuration;
    }

    public abstract EntityManager build();

    private B cast() {
        return (B)this;
    }

    static class BuilderEntityManagerConfiguration
    implements EntityManagerConfiguration {
        private SchemaConfiguration schemaConfiguration;
        private TableNameConverter tableNameConverter;
        private FieldNameConverter fieldNameConverter;
        private boolean useWeakCache = false;

        BuilderEntityManagerConfiguration() {
        }

        public boolean useWeakCache() {
            return this.useWeakCache;
        }

        public TableNameConverter getTableNameConverter() {
            return this.tableNameConverter != null ? this.tableNameConverter : new CamelCaseTableNameConverter();
        }

        public FieldNameConverter getFieldNameConverter() {
            return this.fieldNameConverter != null ? this.fieldNameConverter : new CamelCaseFieldNameConverter();
        }

        public void setUseWeakCache(boolean useWeakCache) {
            this.useWeakCache = useWeakCache;
        }

        public void setTableNameConverter(TableNameConverter tableNameConverter) {
            this.tableNameConverter = tableNameConverter;
        }

        public void setFieldNameConverter(FieldNameConverter fieldNameConverter) {
            this.fieldNameConverter = fieldNameConverter;
        }

        public SchemaConfiguration getSchemaConfiguration() {
            return this.schemaConfiguration != null ? this.schemaConfiguration : new DefaultSchemaConfiguration();
        }

        public void setSchemaConfiguration(SchemaConfiguration schemaConfiguration) {
            this.schemaConfiguration = schemaConfiguration;
        }
    }
}

