/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.event;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.java.ao.event.EventListener;
import net.java.ao.event.ListenerInvoker;
import net.java.ao.event.ListenerInvokerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SingleParameterAnnotatedMethodListenerInvokerFactory
implements ListenerInvokerFactory {
    private static final Class ANNOTATION = EventListener.class;

    SingleParameterAnnotatedMethodListenerInvokerFactory() {
    }

    @Override
    public List<ListenerInvoker> getInvokers(final Object listener) {
        List<Method> methods = this.getValidMethods(listener);
        if (methods.isEmpty()) {
            throw new RuntimeException("No valid method found for listener of type " + listener.getClass().getName());
        }
        return Lists.transform(methods, (Function)new Function<Method, ListenerInvoker>(){

            public ListenerInvoker apply(Method method) {
                return new SingleParameterMethodListenerInvoker(listener, method);
            }
        });
    }

    private List<Method> getValidMethods(Object listener) {
        ArrayList annotatedMethods = Lists.newArrayList();
        for (Method method : listener.getClass().getMethods()) {
            if (!this.isValidMethod(method)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private boolean isValidMethod(Method method) {
        if (this.isAnnotated(method)) {
            if (this.hasOneAndOnlyOneParameter(method)) {
                return true;
            }
            throw new RuntimeException("Method <" + method + "> of class <" + method.getDeclaringClass() + "> " + "is annotated with <" + ANNOTATION.getClass().getName() + "> but has 0 or more than 1 parameters! " + "Listener methods MUST have 1 and only 1 parameter.");
        }
        return false;
    }

    private boolean isAnnotated(Method method) {
        return method.getAnnotation(ANNOTATION) != null;
    }

    private boolean hasOneAndOnlyOneParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleParameterMethodListenerInvoker
    implements ListenerInvoker {
        private final Object listener;
        private final Method method;

        public SingleParameterMethodListenerInvoker(Object listener, Method method) {
            this.listener = listener;
            this.method = method;
        }

        @Override
        public Set<Class<?>> getSupportedEventTypes() {
            return Sets.newHashSet((Object[])this.method.getParameterTypes());
        }

        @Override
        public void invoke(Object event) {
            try {
                this.method.invoke(this.listener, event);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() == null) {
                    throw new RuntimeException(e);
                }
                if (e.getCause().getMessage() == null) {
                    throw new RuntimeException(e.getCause());
                }
                throw new RuntimeException(e.getCause().getMessage(), e.getCause());
            }
        }
    }
}

