/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.Common;
import net.java.ao.RawEntity;
import net.java.ao.schema.AbstractTableNameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnderscoreTableNameConverter
extends AbstractTableNameConverter {
    private static final Pattern WORD_PATTERN = Pattern.compile("([a-z\\d])([A-Z\\d])");
    private boolean uppercase;

    public UnderscoreTableNameConverter(boolean uppercase) {
        this.uppercase = uppercase;
    }

    public boolean isUppercase() {
        return this.uppercase;
    }

    @Override
    protected String convertName(Class<? extends RawEntity<?>> entity) {
        Matcher matcher = WORD_PATTERN.matcher(Common.convertSimpleClassName(entity.getCanonicalName()));
        return matcher.replaceAll("$1_$2");
    }

    @Override
    protected String postProcessName(String back) {
        if (this.uppercase) {
            return back.toUpperCase();
        }
        return back.toLowerCase();
    }
}

