/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.ao.Common;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityType<T>
extends DatabaseType<RawEntity<T>> {
    private DatabaseType<T> primaryKeyType;

    public EntityType(Class<? extends RawEntity<T>> type) {
        super(4, -1, RawEntity.class);
        this.primaryKeyType = Common.getPrimaryKeyType(type);
    }

    @Override
    public int getType() {
        return this.primaryKeyType.getType();
    }

    @Override
    public void putToDatabase(EntityManager manager, PreparedStatement stmt, int index, RawEntity value) throws SQLException {
        DatabaseType dbType = Common.getPrimaryKeyType(value.getEntityType());
        dbType.putToDatabase(manager, stmt, index, Common.getPrimaryKeyValue(value));
    }

    @Override
    public RawEntity<T> pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends RawEntity<T>> type, String field) throws SQLException {
        DatabaseType dbType = Common.getPrimaryKeyType(type);
        Class pkType = Common.getPrimaryKeyClassType(type);
        return Common.createPeer(manager, type, dbType.pullFromDatabase(manager, res, pkType, field));
    }

    @Override
    public String getDefaultName() {
        return this.primaryKeyType.getDefaultName();
    }

    @Override
    public Object defaultParseValue(String value) {
        return Integer.parseInt(value);
    }

    @Override
    public int hashCode() {
        return (super.hashCode() + this.primaryKeyType.hashCode()) % 2048;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj instanceof EntityType) {
                if (((EntityType)obj).primaryKeyType.equals(this.primaryKeyType)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

