/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.java.ao.EntityManager;
import net.java.ao.types.DatabaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimestampType
extends DatabaseType<Calendar> {
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TimestampType() {
        super(93, -1, Calendar.class);
    }

    @Override
    public String getDefaultName() {
        return "TIMESTAMP";
    }

    @Override
    public void putToDatabase(EntityManager manager, PreparedStatement stmt, int index, Calendar value) throws SQLException {
        stmt.setTimestamp(index, new Timestamp(value.getTimeInMillis()));
    }

    @Override
    public Calendar pullFromDatabase(EntityManager manager, ResultSet res, Class<? extends Calendar> type, String field) throws SQLException {
        Calendar back = Calendar.getInstance();
        back.setTime(res.getTimestamp(field));
        return back;
    }

    @Override
    public Calendar defaultParseValue(String value) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.dateFormat.parse(value));
            return cal;
        }
        catch (ParseException parseException) {
            return Calendar.getInstance();
        }
    }

    @Override
    public String valueToString(Object value) {
        return this.dateFormat.format(((Calendar)value).getTime());
    }
}

