/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.java.ao.Accessor;
import net.java.ao.AnnotationDelegate;
import net.java.ao.DatabaseFunction;
import net.java.ao.EntityManager;
import net.java.ao.ManyToMany;
import net.java.ao.MethodFinder;
import net.java.ao.Mutator;
import net.java.ao.OneToMany;
import net.java.ao.OneToOne;
import net.java.ao.Polymorphic;
import net.java.ao.RawEntity;
import net.java.ao.Searchable;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.TypeManager;

public final class Common {
    public static <T extends RawEntity<K>, K> T createPeer(EntityManager manager, Class<T> type, K key) {
        return manager.peer(type, key);
    }

    public static String convertSimpleClassName(String name) {
        String[] array = name.split("\\.");
        return array[array.length - 1];
    }

    public static String convertDowncaseName(String name) {
        StringBuilder back = new StringBuilder();
        back.append(Character.toLowerCase(name.charAt(0)));
        back.append(name.substring(1));
        return back.toString();
    }

    public static boolean interfaceInheritsFrom(Class<?> type, Class<?> superType) {
        return Common.typeInstanceOf(type, superType);
    }

    public static boolean typeInstanceOf(Class<?> type, Class<?> otherType) {
        return otherType.isAssignableFrom(type);
    }

    public static String[] getMappingFields(FieldNameConverter converter, Class<? extends RawEntity<?>> from, Class<? extends RawEntity<?>> to) {
        LinkedHashSet<String> back = new LinkedHashSet<String>();
        for (Method method : from.getMethods()) {
            Class<?> attributeType = Common.getAttributeTypeFromMethod(method);
            if (attributeType == null) continue;
            if (Common.interfaceInheritsFrom(attributeType, to)) {
                back.add(converter.getName(method));
                continue;
            }
            if (attributeType.getAnnotation(Polymorphic.class) == null || !Common.interfaceInheritsFrom(to, attributeType)) continue;
            back.add(converter.getName(method));
        }
        return back.toArray(new String[back.size()]);
    }

    public static String[] getPolymorphicFieldNames(FieldNameConverter converter, Class<? extends RawEntity<?>> from, Class<? extends RawEntity<?>> to) {
        LinkedHashSet<String> back = new LinkedHashSet<String>();
        for (Method method : from.getMethods()) {
            Class<?> attributeType = Common.getAttributeTypeFromMethod(method);
            if (attributeType == null || !Common.interfaceInheritsFrom(to, attributeType) || attributeType.getAnnotation(Polymorphic.class) == null) continue;
            back.add(converter.getPolyTypeName(method));
        }
        return back.toArray(new String[back.size()]);
    }

    public static AnnotationDelegate getAnnotationDelegate(FieldNameConverter converter, Method method) {
        return new AnnotationDelegate(method, Common.findCounterpart(converter, method));
    }

    public static Method findCounterpart(FieldNameConverter converter, Method method) {
        return MethodFinder.getInstance().findCounterpart(converter, method);
    }

    public static boolean isMutator(Method method) {
        return (Common.isAnnotatedMutator(method) || Common.isNamedAsSetter(method)) && Common.isValidMutator(method);
    }

    public static boolean isAnnotatedMutator(Method method) {
        return method.isAnnotationPresent(Mutator.class);
    }

    private static boolean isNamedAsSetter(Method method) {
        return method.getName().startsWith("set");
    }

    private static boolean isValidMutator(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1;
    }

    public static boolean isAccessor(Method method) {
        return (Common.isAnnotatedAccessor(method) || Common.isNamedAsGetter(method)) && Common.isValidAccessor(method);
    }

    private static boolean isAnnotatedAccessor(Method method) {
        return method.isAnnotationPresent(Accessor.class);
    }

    private static boolean isNamedAsGetter(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }

    private static boolean isValidAccessor(Method method) {
        return method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean isAnnotatedAsRelational(Method method) {
        return method.isAnnotationPresent(OneToOne.class) || method.isAnnotationPresent(OneToMany.class) || method.isAnnotationPresent(ManyToMany.class);
    }

    public static Class<?> getAttributeTypeFromMethod(Method method) {
        if (Common.isAnnotatedAsRelational(method)) {
            return null;
        }
        if (Common.isMutator(method)) {
            return Common.getMutatorParameterType(method);
        }
        if (Common.isAccessor(method)) {
            return Common.getAccessorReturnType(method);
        }
        return null;
    }

    private static Class<?> getMutatorParameterType(Method method) {
        Preconditions.checkArgument((boolean)Common.isValidMutator(method), (String)"Method '%s' on class '%s' is not a valid mutator", (Object[])new Object[]{method.getName(), method.getDeclaringClass().getCanonicalName()});
        return method.getParameterTypes()[0];
    }

    private static Class<?> getAccessorReturnType(Method method) {
        Preconditions.checkArgument((boolean)Common.isValidAccessor(method), (String)"Method '%s' on class '%s' is not a valid accessor", (Object[])new Object[]{method.getName(), method.getDeclaringClass().getCanonicalName()});
        return method.getReturnType();
    }

    public static Class<?> getCallingClass(int depth) {
        StackTraceElement[] stack = new Exception().getStackTrace();
        try {
            return Class.forName(stack[depth + 2].getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static List<String> getSearchableFields(EntityManager manager, Class<? extends RawEntity<?>> type) {
        ArrayList<String> back = new ArrayList<String>();
        for (Method m : type.getMethods()) {
            Searchable annot = Common.getAnnotationDelegate(manager.getFieldNameConverter(), m).getAnnotation(Searchable.class);
            if (annot == null) continue;
            Class<?> attributeType = Common.getAttributeTypeFromMethod(m);
            String name = manager.getFieldNameConverter().getName(m);
            if (name == null || Common.interfaceInheritsFrom(attributeType, RawEntity.class) || back.contains(name)) continue;
            back.add(name);
        }
        return back;
    }

    public static Method getPrimaryKeyAccessor(Class<? extends RawEntity<?>> type) {
        Method[] methods = MethodFinder.getInstance().findAnnotation(PrimaryKey.class, type);
        if (methods.length == 0) {
            throw new RuntimeException("Entity " + type.getSimpleName() + " has no primary key field");
        }
        for (Method method : methods) {
            if (method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    public static String getPrimaryKeyField(Class<? extends RawEntity<?>> type, FieldNameConverter converter) {
        Method[] annotatedMethods = MethodFinder.getInstance().findAnnotation(PrimaryKey.class, type);
        if (annotatedMethods.length == 0) {
            throw new RuntimeException("Entity " + type.getSimpleName() + " has no primary key field");
        }
        return converter.getName(annotatedMethods[0]);
    }

    public static Method getPrimaryKeyMethod(Class<? extends RawEntity<?>> type) {
        Method[] annotatedMethods = MethodFinder.getInstance().findAnnotation(PrimaryKey.class, type);
        if (annotatedMethods.length == 0) {
            throw new RuntimeException("Entity " + type.getSimpleName() + " has no primary key field");
        }
        return annotatedMethods[0];
    }

    public static <K> DatabaseType<K> getPrimaryKeyType(Class<? extends RawEntity<K>> type) {
        return TypeManager.getInstance().getType(Common.getPrimaryKeyClassType(type));
    }

    public static <K> Class<K> getPrimaryKeyClassType(Class<? extends RawEntity<K>> type) {
        Method[] annotatedMethods = MethodFinder.getInstance().findAnnotation(PrimaryKey.class, type);
        if (annotatedMethods.length == 0) {
            throw new RuntimeException("Entity " + type.getSimpleName() + " has no primary key field");
        }
        Method meth = annotatedMethods[0];
        Class<?> keyType = meth.getReturnType();
        if (keyType.equals(Void.TYPE)) {
            keyType = meth.getParameterTypes()[0];
        }
        return keyType;
    }

    public static <K> K getPrimaryKeyValue(RawEntity<K> entity) {
        try {
            return (K)Common.getPrimaryKeyAccessor(entity.getEntityType()).invoke(entity, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static boolean fuzzyCompare(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Object array = null;
        Object other = null;
        if (a.getClass().isArray()) {
            array = a;
            other = b;
        } else if (b.getClass().isArray()) {
            array = b;
            other = a;
        }
        if (array != null) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (!Common.fuzzyCompare(Array.get(array, i), other)) continue;
                return true;
            }
        }
        if (a instanceof DatabaseFunction) {
            return a.equals(b);
        }
        return TypeManager.getInstance().getType(a.getClass()).valueEquals(a, b) || TypeManager.getInstance().getType(b.getClass()).valueEquals(b, a);
    }

    public static boolean fuzzyTypeCompare(int typeA, int typeB) {
        if (typeA == 16) {
            switch (typeB) {
                case -5: {
                    return true;
                }
                case -7: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case -6: {
                    return true;
                }
            }
        }
        if ((typeA == -5 || typeA == -7 || typeA == 4 || typeA == 2 || typeA == 5 || typeA == -6) && typeB == 16) {
            return true;
        }
        if (typeA == 2005 && (typeB == -1 || typeB == 12)) {
            return true;
        }
        if ((typeA == -1 || typeA == 12) && typeB == 2005) {
            return true;
        }
        if ((typeA == -5 || typeA == -7 || typeA == 3 || typeA == 8 || typeA == 6 || typeA == 4 || typeA == 7 || typeA == 5 || typeA == -6) && typeB == 2) {
            return true;
        }
        return typeA == typeB;
    }

    public static Set<Method> getValueFieldsMethods(Class<? extends RawEntity<?>> entity, final FieldNameConverter converter) {
        return Sets.filter((Set)Sets.newHashSet((Object[])entity.getMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method m) {
                AnnotationDelegate annotations = Common.getAnnotationDelegate(converter, m);
                return !annotations.isAnnotationPresent(Ignore.class) && !annotations.isAnnotationPresent(OneToOne.class) && !annotations.isAnnotationPresent(OneToMany.class) && !annotations.isAnnotationPresent(ManyToMany.class);
            }
        });
    }

    public static Set<String> getValueFieldsNames(Class<? extends RawEntity<?>> entity, final FieldNameConverter converter) {
        return Sets.newHashSet((Iterable)Iterables.transform(Common.getValueFieldsMethods(entity, converter), (Function)new Function<Method, String>(){

            public String apply(Method m) {
                return converter.getName(m);
            }
        }));
    }

    public static void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

