/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.RawEntity;
import net.java.ao.schema.FieldNameConverter;

final class MethodFinder {
    private static MethodFinder instance;
    private Map<AnnotationCacheKey, Method[]> annotationCache = new HashMap<AnnotationCacheKey, Method[]>();
    private final ReadWriteLock annotationCacheLock = new ReentrantReadWriteLock();
    private Map<CounterpartCacheKey, Method> counterpartCache = new HashMap<CounterpartCacheKey, Method>();
    private final ReadWriteLock counterpartCacheLock = new ReentrantReadWriteLock();

    private MethodFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method[] findAnnotation(Class<? extends Annotation> annotation, Class<? extends RawEntity<?>> clazz) {
        AnnotationCacheKey key = new AnnotationCacheKey(annotation, clazz);
        this.annotationCacheLock.writeLock().lock();
        try {
            if (this.annotationCache.containsKey(key)) {
                Method[] methodArray = this.annotationCache.get(key);
                return methodArray;
            }
            ArrayList<Method> back = new ArrayList<Method>();
            for (Method method : clazz.getMethods()) {
                if (method.getAnnotation(annotation) == null) continue;
                back.add(method);
            }
            Method[] array = back.toArray(new Method[back.size()]);
            this.annotationCache.put(key, array);
            Method[] methodArray = array;
            return methodArray;
        }
        finally {
            this.annotationCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method findCounterpart(FieldNameConverter converter, Method method) {
        CounterpartCacheKey key = new CounterpartCacheKey(converter, method);
        String name = converter.getName(method);
        this.counterpartCacheLock.writeLock().lock();
        try {
            if (this.counterpartCache.containsKey(key)) {
                Method method2 = this.counterpartCache.get(key);
                return method2;
            }
            Class<?> clazz = method.getDeclaringClass();
            for (Method other : clazz.getMethods()) {
                String otherName = converter.getName(other);
                if (other.equals(method) || otherName == null || !otherName.equals(name)) continue;
                this.counterpartCache.put(key, other);
                Method method3 = other;
                return method3;
            }
            this.counterpartCache.put(key, null);
            Method method4 = null;
            return method4;
        }
        finally {
            this.counterpartCacheLock.writeLock().unlock();
        }
    }

    public static synchronized MethodFinder getInstance() {
        if (instance == null) {
            instance = new MethodFinder();
        }
        return instance;
    }

    private static final class CounterpartCacheKey {
        private final FieldNameConverter converter;
        private final Method method;

        public CounterpartCacheKey(FieldNameConverter converter, Method method) {
            this.converter = converter;
            this.method = method;
        }

        public FieldNameConverter getConverter() {
            return this.converter;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            return this.converter.hashCode() + this.method.hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof CounterpartCacheKey) {
                CounterpartCacheKey key = (CounterpartCacheKey)obj;
                return key.converter == this.converter && key.method == this.method;
            }
            return false;
        }
    }

    private static final class AnnotationCacheKey {
        private Class<? extends Annotation> annotation;
        private Class<? extends RawEntity<?>> type;

        public AnnotationCacheKey(Class<? extends Annotation> annotation, Class<? extends RawEntity<?>> type) {
            this.annotation = annotation;
            this.type = type;
        }

        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public Class<? extends RawEntity<?>> getType() {
            return this.type;
        }

        public void setType(Class<? extends RawEntity<?>> type) {
            this.type = type;
        }

        public int hashCode() {
            int back = 0;
            if (this.annotation != null) {
                back += this.annotation.hashCode();
            }
            if (this.type != null) {
                back += this.type.hashCode();
            }
            return back %= 65536;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AnnotationCacheKey) {
                AnnotationCacheKey key = (AnnotationCacheKey)obj;
                return key.getAnnotation().equals(this.annotation) && key.getType().equals(this.type);
            }
            return super.equals(obj);
        }
    }
}

