/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.sql.Connection;
import java.sql.SQLException;
import net.java.ao.DelegateConnection;
import net.java.ao.EntityManager;

public abstract class Transaction<T> {
    private EntityManager manager;

    public Transaction(EntityManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("EntityManager instance cannot be null");
        }
        this.manager = manager;
    }

    protected final EntityManager getEntityManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute() throws SQLException {
        Connection conn = null;
        TransactionState state = TransactionState.START;
        T back = null;
        try {
            conn = this.manager.getProvider().getConnection();
            this.setCloseable(conn, false);
            conn.setTransactionIsolation(8);
            conn.setAutoCommit(false);
            state = TransactionState.RUNNING;
            back = this.run();
            conn.commit();
            state = TransactionState.COMMITTED;
        }
        finally {
            if (conn == null) {
                return null;
            }
            if (state == TransactionState.RUNNING) {
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {}
            }
            try {
                conn.setAutoCommit(true);
                this.setCloseable(conn, true);
                conn.close();
            }
            catch (SQLException e) {}
        }
        return back;
    }

    private void setCloseable(Connection connection, boolean closeable) {
        if (connection instanceof DelegateConnection) {
            ((DelegateConnection)connection).setCloseable(closeable);
        }
    }

    protected abstract T run() throws SQLException;

    private static enum TransactionState {
        START,
        RUNNING,
        COMMITTED;

    }
}

