/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.RawEntity;
import net.java.ao.cache.CacheLayer;

class RAMCacheLayer
implements CacheLayer {
    private Map<String, Object> values;
    private final ReadWriteLock valueLock = new ReentrantReadWriteLock();
    private Set<String> dirty;
    private final ReadWriteLock dirtyLock = new ReentrantReadWriteLock();
    private Set<Class<? extends RawEntity<?>>> flush;
    private final ReadWriteLock flushLock = new ReentrantReadWriteLock();

    RAMCacheLayer() {
        this.values = new HashMap<String, Object>();
        this.dirty = new HashSet<String>();
        this.flush = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.dirtyLock.readLock().lock();
        this.valueLock.writeLock().lock();
        try {
            HashSet<String> toRemove = new HashSet<String>();
            for (String field : this.values.keySet()) {
                if (this.dirty.contains(field)) continue;
                toRemove.add(field);
            }
            for (String field : toRemove) {
                this.values.remove(field);
            }
        }
        finally {
            this.valueLock.writeLock().unlock();
            this.dirtyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDirty() {
        this.dirtyLock.writeLock().lock();
        try {
            this.dirty.clear();
        }
        finally {
            this.dirtyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFlush() {
        this.flushLock.writeLock().lock();
        try {
            this.flush.clear();
        }
        finally {
            this.flushLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String field) {
        this.valueLock.readLock().lock();
        try {
            boolean bl = this.values.containsKey(field);
            return bl;
        }
        finally {
            this.valueLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dirtyContains(String field) {
        this.dirtyLock.readLock().lock();
        try {
            boolean bl = this.dirty.contains(field);
            return bl;
        }
        finally {
            this.dirtyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String field) {
        this.valueLock.readLock().lock();
        try {
            Object object = this.values.get(field);
            return object;
        }
        finally {
            this.valueLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDirtyFields() {
        this.dirtyLock.readLock().lock();
        try {
            String[] stringArray = this.dirty.toArray(new String[this.dirty.size()]);
            return stringArray;
        }
        finally {
            this.dirtyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends RawEntity<?>>[] getToFlush() {
        this.flushLock.readLock().lock();
        try {
            Class[] classArray = this.flush.toArray(new Class[this.flush.size()]);
            return classArray;
        }
        finally {
            this.flushLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDirty(String field) {
        this.dirtyLock.writeLock().lock();
        try {
            this.dirty.add(field);
        }
        finally {
            this.dirtyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markToFlush(Class<? extends RawEntity<?>> type) {
        this.flushLock.writeLock().lock();
        try {
            this.flush.add(type);
        }
        finally {
            this.flushLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String field, Object value) {
        this.valueLock.writeLock().lock();
        try {
            this.values.put(field, value);
        }
        finally {
            this.valueLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String field) {
        this.valueLock.writeLock().lock();
        try {
            this.values.remove(field);
        }
        finally {
            this.valueLock.writeLock().unlock();
        }
    }
}

