/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.java.ao.AnnotationDelegate;
import net.java.ao.Common;
import net.java.ao.DatabaseFunction;
import net.java.ao.DatabaseProvider;
import net.java.ao.Polymorphic;
import net.java.ao.RawEntity;
import net.java.ao.SchemaConfiguration;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Default;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.OnUpdate;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.SQLType;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.Unique;
import net.java.ao.schema.ddl.DDLAction;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLForeignKey;
import net.java.ao.schema.ddl.DDLIndex;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.schema.ddl.SchemaReader;
import net.java.ao.types.DatabaseType;
import net.java.ao.types.TypeManager;

public final class SchemaGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(DatabaseProvider provider, SchemaConfiguration schemaConfiguration, TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> ... classes) throws SQLException {
        String[] statements;
        try {
            statements = SchemaGenerator.generateImpl(provider, schemaConfiguration, nameConverter, fieldConverter, SchemaGenerator.class.getClassLoader(), classes);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        Connection conn = provider.getConnection();
        try {
            Statement stmt = conn.createStatement();
            for (String statement : statements) {
                if (statement.trim().equals("")) continue;
                provider.executeUpdate(stmt, statement);
            }
            stmt.close();
        }
        finally {
            conn.close();
        }
    }

    private static String[] generateImpl(DatabaseProvider provider, SchemaConfiguration schemaConfiguration, TableNameConverter nameConverter, FieldNameConverter fieldConverter, ClassLoader classloader, Class<? extends RawEntity<?>> ... classes) throws ClassNotFoundException, SQLException {
        DDLAction[] actions;
        ArrayList<String> back = new ArrayList<String>();
        DDLTable[] parsedTables = SchemaGenerator.parseDDL(nameConverter, fieldConverter, classloader, classes);
        DDLTable[] readTables = SchemaReader.readSchema(provider, schemaConfiguration);
        for (DDLAction action : actions = SchemaReader.sortTopologically(SchemaReader.diffSchema(parsedTables, readTables, provider.isCaseSensetive()))) {
            back.addAll(Arrays.asList(provider.renderAction(action)));
        }
        return back.toArray(new String[back.size()]);
    }

    static DDLTable[] parseDDL(TableNameConverter nameConverter, FieldNameConverter fieldConverter, ClassLoader classloader, Class<? extends RawEntity<?>> ... classes) {
        HashMap deps = new HashMap();
        LinkedHashSet roots = new LinkedHashSet();
        for (Class<RawEntity<?>> clazz : classes) {
            try {
                SchemaGenerator.parseDependencies(fieldConverter, deps, roots, clazz);
            }
            catch (StackOverflowError e) {
                throw new RuntimeException("Circular dependency detected in or below " + clazz.getCanonicalName());
            }
        }
        ArrayList<DDLTable> parsedTables = new ArrayList<DDLTable>();
        while (!roots.isEmpty()) {
            Class[] rootsArray = roots.toArray(new Class[roots.size()]);
            roots.remove(rootsArray[0]);
            Class clazz = rootsArray[0];
            if (clazz.getAnnotation(Polymorphic.class) == null) {
                parsedTables.add(SchemaGenerator.parseInterface(nameConverter, fieldConverter, clazz));
            }
            LinkedList<Class> linkedList = new LinkedList<Class>();
            for (Class depClass : deps.keySet()) {
                Set individualDeps = (Set)deps.get(depClass);
                individualDeps.remove(clazz);
                if (!individualDeps.isEmpty()) continue;
                roots.add(depClass);
                linkedList.add(depClass);
            }
            for (Class remove : linkedList) {
                deps.remove(remove);
            }
        }
        return parsedTables.toArray(new DDLTable[parsedTables.size()]);
    }

    private static void parseDependencies(FieldNameConverter fieldConverter, Map<Class<? extends RawEntity<?>>, Set<Class<? extends RawEntity<?>>>> deps, Set<Class<? extends RawEntity<?>>> roots, Class<? extends RawEntity<?>> ... classes) {
        for (Class<RawEntity<?>> clazz : classes) {
            if (deps.containsKey(clazz)) continue;
            LinkedHashSet individualDeps = new LinkedHashSet();
            for (Method method : clazz.getMethods()) {
                String attributeName = fieldConverter.getName(method);
                Class<?> type = Common.getAttributeTypeFromMethod(method);
                if (attributeName == null || type == null || !Common.interfaceInheritsFrom(type, RawEntity.class) || type.equals(clazz)) continue;
                individualDeps.add(type);
                SchemaGenerator.parseDependencies(fieldConverter, deps, roots, type);
            }
            if (individualDeps.size() == 0) {
                roots.add(clazz);
                continue;
            }
            deps.put(clazz, individualDeps);
        }
    }

    private static DDLTable parseInterface(TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        String sqlName = nameConverter.getName(clazz);
        DDLTable table = new DDLTable();
        table.setName(sqlName);
        table.setFields(SchemaGenerator.parseFields(clazz, fieldConverter));
        table.setForeignKeys(SchemaGenerator.parseForeignKeys(nameConverter, fieldConverter, clazz));
        table.setIndexes(SchemaGenerator.parseIndexes(nameConverter, fieldConverter, clazz));
        return table;
    }

    public static DDLField[] parseFields(Class<? extends RawEntity<?>> clazz, FieldNameConverter fieldConverter) {
        ArrayList<DDLField> fields = new ArrayList<DDLField>();
        LinkedList<String> attributes = new LinkedList<String>();
        for (Method method : Common.getValueFieldsMethods(clazz, fieldConverter)) {
            String attributeName = fieldConverter.getName(method);
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            if (attributeName == null || type == null || attributes.contains(attributeName)) continue;
            attributes.add(attributeName);
            AnnotationDelegate annotations = Common.getAnnotationDelegate(fieldConverter, method);
            DDLField field = new DDLField();
            field.setName(attributeName);
            DatabaseType<?> sqlType = SchemaGenerator.getSQLTypeFromMethod(type, annotations);
            field.setType(sqlType);
            field.setPrecision(SchemaGenerator.getPrecisionFromMethod(type, method, fieldConverter));
            field.setScale(SchemaGenerator.getScaleFromMethod(type, method, fieldConverter));
            field.setPrimaryKey(annotations.isAnnotationPresent(PrimaryKey.class));
            field.setNotNull(annotations.isAnnotationPresent(NotNull.class));
            field.setUnique(annotations.isAnnotationPresent(Unique.class));
            boolean isAutoIncrement = annotations.isAnnotationPresent(AutoIncrement.class);
            field.setAutoIncrement(isAutoIncrement);
            if (!isAutoIncrement && annotations.isAnnotationPresent(Default.class)) {
                field.setDefaultValue(SchemaGenerator.convertStringValue(annotations.getAnnotation(Default.class).value(), sqlType));
            }
            if (annotations.isAnnotationPresent(OnUpdate.class)) {
                field.setOnUpdate(SchemaGenerator.convertStringValue(annotations.getAnnotation(OnUpdate.class).value(), sqlType));
            }
            if (field.isPrimaryKey()) {
                fields.add(0, field);
            } else {
                fields.add(field);
            }
            if (!Common.interfaceInheritsFrom(type, RawEntity.class) || type.getAnnotation(Polymorphic.class) == null) continue;
            field.setDefaultValue(null);
            field.setOnUpdate(null);
            attributeName = fieldConverter.getPolyTypeName(method);
            field = new DDLField();
            field.setName(attributeName);
            field.setType(TypeManager.getInstance().getType(String.class));
            field.setPrecision(127);
            field.setScale(-1);
            if (annotations.getAnnotation(NotNull.class) != null) {
                field.setNotNull(true);
            }
            fields.add(field);
        }
        return fields.toArray(new DDLField[fields.size()]);
    }

    private static DatabaseType<?> getSQLTypeFromMethod(Class<?> type, AnnotationDelegate annotations) {
        int annoType;
        DatabaseType<?> sqlType = null;
        TypeManager manager = TypeManager.getInstance();
        sqlType = manager.getType(type);
        SQLType sqlTypeAnnotation = annotations.getAnnotation(SQLType.class);
        if (sqlTypeAnnotation != null && (annoType = sqlTypeAnnotation.value()) != 0) {
            sqlType = manager.getType(annoType);
        }
        return sqlType;
    }

    private static int getPrecisionFromMethod(Class<?> type, Method method, FieldNameConverter converter) {
        TypeManager manager = TypeManager.getInstance();
        int precision = -1;
        precision = manager.getType(type).getDefaultPrecision();
        SQLType sqlTypeAnnotation = Common.getAnnotationDelegate(converter, method).getAnnotation(SQLType.class);
        if (sqlTypeAnnotation != null) {
            precision = sqlTypeAnnotation.precision();
        }
        return precision;
    }

    private static int getScaleFromMethod(Class<?> type, Method method, FieldNameConverter converter) {
        int scale = -1;
        SQLType sqlTypeAnnotation = Common.getAnnotationDelegate(converter, method).getAnnotation(SQLType.class);
        if (sqlTypeAnnotation != null) {
            scale = sqlTypeAnnotation.scale();
        }
        return scale;
    }

    private static DDLForeignKey[] parseForeignKeys(TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        LinkedHashSet<DDLForeignKey> back = new LinkedHashSet<DDLForeignKey>();
        for (Method method : clazz.getMethods()) {
            String attributeName = fieldConverter.getName(method);
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            if (type == null || attributeName == null || !Common.interfaceInheritsFrom(type, RawEntity.class) || type.getAnnotation(Polymorphic.class) != null) continue;
            DDLForeignKey key = new DDLForeignKey();
            key.setField(attributeName);
            key.setTable(nameConverter.getName(type));
            key.setForeignField(Common.getPrimaryKeyField(type, fieldConverter));
            key.setDomesticTable(nameConverter.getName(clazz));
            back.add(key);
        }
        return back.toArray(new DDLForeignKey[back.size()]);
    }

    private static DDLIndex[] parseIndexes(TableNameConverter nameConverter, FieldNameConverter fieldConverter, Class<? extends RawEntity<?>> clazz) {
        LinkedHashSet<DDLIndex> back = new LinkedHashSet<DDLIndex>();
        String tableName = nameConverter.getName(clazz);
        for (Method method : clazz.getMethods()) {
            String attributeName = fieldConverter.getName(method);
            AnnotationDelegate annotations = Common.getAnnotationDelegate(fieldConverter, method);
            if (!Common.isAccessor(method) && !Common.isMutator(method)) continue;
            Indexed indexedAnno = annotations.getAnnotation(Indexed.class);
            Class<?> type = Common.getAttributeTypeFromMethod(method);
            if (indexedAnno == null && (type == null || !Common.interfaceInheritsFrom(type, RawEntity.class))) continue;
            DDLIndex index = new DDLIndex();
            index.setField(attributeName);
            index.setTable(tableName);
            index.setType(SchemaGenerator.getSQLTypeFromMethod(type, annotations));
            back.add(index);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            if (genericDeclaration.equals(RawEntity.class) || ((Class)genericDeclaration).isAnnotationPresent(Polymorphic.class)) continue;
            back.addAll(Arrays.asList(SchemaGenerator.parseIndexes(nameConverter, fieldConverter, genericDeclaration)));
        }
        return back.toArray(new DDLIndex[back.size()]);
    }

    private static Object convertStringValue(String value, DatabaseType<?> type) {
        if (value == null) {
            return null;
        }
        if (value.trim().equalsIgnoreCase("NULL")) {
            return value.trim();
        }
        DatabaseFunction func = DatabaseFunction.get(value.trim());
        if (func != null) {
            return func;
        }
        return type.defaultParseValue(value);
    }
}

