/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import java.util.Arrays;
import net.java.ao.RawEntity;

final class MemoryRelationsCacheKey {
    private final RawEntity<?> from;
    private final Class<? extends RawEntity<?>> toType;
    private final Class<? extends RawEntity<?>> throughType;
    private final String[] fields;
    private final String where;

    public MemoryRelationsCacheKey(RawEntity<?> from, Class<? extends RawEntity<?>> toType, Class<? extends RawEntity<?>> throughType, String[] fields, String where) {
        this.from = from;
        this.toType = toType;
        this.throughType = throughType;
        this.fields = MemoryRelationsCacheKey.sortFields(fields);
        this.where = where;
    }

    public RawEntity<?> getFrom() {
        return this.from;
    }

    public Class<? extends RawEntity<?>> getToType() {
        return this.toType;
    }

    public String[] getFields() {
        return this.fields;
    }

    public Class<? extends RawEntity<?>> getThroughType() {
        return this.throughType;
    }

    public String toString() {
        return '(' + this.from.toString() + "; to=" + this.toType.getName() + "; through=" + this.throughType.getName() + "; " + Arrays.toString(this.fields) + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRelationsCacheKey cacheKey = (MemoryRelationsCacheKey)o;
        if (!Arrays.equals(this.fields, cacheKey.fields)) {
            return false;
        }
        if (this.from != null ? !this.from.equals(cacheKey.from) : cacheKey.from != null) {
            return false;
        }
        if (this.throughType != null ? !this.throughType.equals(cacheKey.throughType) : cacheKey.throughType != null) {
            return false;
        }
        if (this.toType != null ? !this.toType.equals(cacheKey.toType) : cacheKey.toType != null) {
            return false;
        }
        return !(this.where != null ? !this.where.equals(cacheKey.where) : cacheKey.where != null);
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.toType != null ? this.toType.hashCode() : 0);
        result = 31 * result + (this.throughType != null ? this.throughType.hashCode() : 0);
        result = 31 * result + (this.fields != null ? Arrays.hashCode(this.fields) : 0);
        result = 31 * result + (this.where != null ? this.where.hashCode() : 0);
        return result;
    }

    private static String[] sortFields(String[] fields) {
        Arrays.sort(fields);
        return fields;
    }
}

