/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import net.java.ao.EntityManager;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.LuceneConfiguration;
import net.java.ao.builder.AbstractEntityManagerBuilderWithDatabaseProperties;
import net.java.ao.builder.DatabaseProperties;
import net.java.ao.builder.DatabaseProviderFactory;
import net.java.ao.builder.EntityManagerBuilderWithDatabasePropertiesAndLuceneConfiguration;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityManagerBuilderWithDatabaseProperties
extends AbstractEntityManagerBuilderWithDatabaseProperties<EntityManagerBuilderWithDatabaseProperties> {
    EntityManagerBuilderWithDatabaseProperties(DatabaseProperties databaseProperties) {
        super(databaseProperties);
    }

    public EntityManagerBuilderWithDatabasePropertiesAndLuceneConfiguration withIndex(final File indexDir) {
        Preconditions.checkNotNull((Object)indexDir);
        return new EntityManagerBuilderWithDatabasePropertiesAndLuceneConfiguration(this.getDatabaseProperties(), this.getEntityManagerConfiguration(), this.getEventManager(), new LuceneConfiguration(){

            public Directory getIndexDirectory() {
                try {
                    return FSDirectory.getDirectory((File)indexDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public EntityManager build() {
        return new EntityManager(DatabaseProviderFactory.getDatabaseProvider(this.getDatabaseProperties()), (EntityManagerConfiguration)this.getEntityManagerConfiguration(), this.getEventManager());
    }
}

