/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder;

import com.google.common.base.Preconditions;
import net.java.ao.ActiveObjectsException;
import net.java.ao.builder.ConnectionPool;
import net.java.ao.builder.DatabaseProperties;
import net.java.ao.builder.EntityManagerBuilder;
import net.java.ao.builder.EntityManagerBuilderWithDatabaseProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityManagerBuilderWithUrlAndUsernameAndPassword {
    private final Logger logger = LoggerFactory.getLogger(EntityManagerBuilder.class);
    private final String url;
    private final String username;
    private final String password;

    public EntityManagerBuilderWithUrlAndUsernameAndPassword(String url, String username, String password) {
        this.url = (String)Preconditions.checkNotNull((Object)url);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
    }

    public EntityManagerBuilderWithDatabaseProperties none() {
        return this.getEntityManagerBuilderWithDatabaseProperties(ConnectionPool.NONE);
    }

    public EntityManagerBuilderWithDatabaseProperties dbcp() {
        return this.getEntityManagerBuilderWithDatabaseProperties(ConnectionPool.DBCP);
    }

    public EntityManagerBuilderWithDatabaseProperties proxool() {
        return this.getEntityManagerBuilderWithDatabaseProperties(ConnectionPool.PROXOOL);
    }

    public EntityManagerBuilderWithDatabaseProperties dbPool() {
        return this.getEntityManagerBuilderWithDatabaseProperties(ConnectionPool.DBPOOL);
    }

    public EntityManagerBuilderWithDatabaseProperties c3po() {
        return this.getEntityManagerBuilderWithDatabaseProperties(ConnectionPool.C3PO);
    }

    public EntityManagerBuilderWithDatabaseProperties auto() {
        for (ConnectionPool pool : ConnectionPool.values()) {
            if (!pool.isAvailable()) continue;
            return this.getEntityManagerBuilderWithDatabaseProperties(pool);
        }
        throw new ActiveObjectsException("Could not find any connection pool! Impossible, " + ConnectionPool.NONE + " should always be an option...");
    }

    private EntityManagerBuilderWithDatabaseProperties getEntityManagerBuilderWithDatabaseProperties(ConnectionPool pool) {
        if (pool.isAvailable()) {
            this.logger.debug("Entity manager will be using connection pool '{}'.", (Object)pool);
            return new EntityManagerBuilderWithDatabaseProperties(this.getDatabaseProperties(pool));
        }
        throw new ActiveObjectsException("Connection pool " + pool + " is not available on the classpath");
    }

    private BuilderDatabaseProperties getDatabaseProperties(ConnectionPool connectionPool) {
        return new BuilderDatabaseProperties(this.url, this.username, this.password, connectionPool);
    }

    private static class BuilderDatabaseProperties
    implements DatabaseProperties {
        private final String url;
        private final String username;
        private final String password;
        private final ConnectionPool pool;

        public BuilderDatabaseProperties(String url, String username, String password, ConnectionPool pool) {
            this.url = (String)Preconditions.checkNotNull((Object)url);
            this.username = (String)Preconditions.checkNotNull((Object)username);
            this.password = (String)Preconditions.checkNotNull((Object)password);
            this.pool = (ConnectionPool)Preconditions.checkNotNull((Object)pool);
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public ConnectionPool getConnectionPool() {
            return this.pool;
        }
    }
}

