/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.sql.DataSource;
import net.java.ao.Disposable;
import net.java.ao.DisposableDataSource;

public final class DelegatingDisposableDataSourceHandler
implements InvocationHandler {
    private final DataSource dataSource;
    private final Disposable disposable;

    public DelegatingDisposableDataSourceHandler(DataSource dataSource, Disposable disposable) {
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource);
        this.disposable = (Disposable)Preconditions.checkNotNull((Object)disposable);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (DelegatingDisposableDataSourceHandler.isDisposeMethod(method)) {
            this.disposable.dispose();
        }
        return this.delegate(method, args);
    }

    private Object delegate(Method method, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.dataSource.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this.dataSource, args);
    }

    public static DisposableDataSource newInstance(DataSource ds, Disposable disposable) {
        return (DisposableDataSource)Proxy.newProxyInstance(DelegatingDisposableDataSourceHandler.class.getClassLoader(), new Class[]{DisposableDataSource.class}, (InvocationHandler)new DelegatingDisposableDataSourceHandler(ds, disposable));
    }

    private static boolean isDisposeMethod(Method method) {
        return method.getName().equals("dispose") && method.getParameterTypes().length == 0;
    }
}

